/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.SyntacticEquivalence;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S6211")
public class RecordDuplicatedGetterCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.RECORD);
    }

    public void visitNode(Tree tree) {
        Symbol.TypeSymbol recordSymbol = ((ClassTree)tree).symbol();
        for (Symbol.VariableSymbol component : RecordDuplicatedGetterCheck.recordComponents(recordSymbol)) {
            RecordDuplicatedGetterCheck.findDeclaredMethod(recordSymbol, RecordDuplicatedGetterCheck.getterName(component)).ifPresent(m -> this.checkConflictWithAccessor(recordSymbol, component, (MethodTree)m));
        }
    }

    private static String getterName(Symbol.VariableSymbol component) {
        return (component.type().isPrimitive(Type.Primitives.BOOLEAN) ? "is" : "get") + RecordDuplicatedGetterCheck.upperCaseFirstCharacter(component.name());
    }

    private void checkConflictWithAccessor(Symbol.TypeSymbol recordSymbol, Symbol.VariableSymbol component, MethodTree getter) {
        if (RecordDuplicatedGetterCheck.isDirectCallToAccessor(getter, component) || RecordDuplicatedGetterCheck.isPojoGetter(getter, component)) {
            return;
        }
        Optional<MethodTree> accessor = RecordDuplicatedGetterCheck.findDeclaredMethod(recordSymbol, component.name());
        if (!accessor.isPresent()) {
            this.reportIssue((Tree)getter.simpleName(), RecordDuplicatedGetterCheck.issueMessage(getter, component));
        } else {
            MethodTree accessorMethod = accessor.get();
            if (!SyntacticEquivalence.areEquivalent((Tree)accessorMethod.block(), (Tree)getter.block()) && !RecordDuplicatedGetterCheck.isDirectCallToGetter(accessorMethod, getter)) {
                this.reportIssue((Tree)getter.simpleName(), RecordDuplicatedGetterCheck.issueMessage(getter, component));
            }
        }
    }

    private static boolean isPojoGetter(MethodTree method, Symbol.VariableSymbol component) {
        return RecordDuplicatedGetterCheck.singleReturnStatementExpression(method).filter(expr -> RecordDuplicatedGetterCheck.isComponent(expr, component)).isPresent();
    }

    private static boolean isDirectCallToAccessor(MethodTree getter, Symbol.VariableSymbol component) {
        return RecordDuplicatedGetterCheck.singleReturnStatementExpression(getter).filter(expr -> RecordDuplicatedGetterCheck.isAccessorInvocation(expr, component)).isPresent();
    }

    private static boolean isDirectCallToGetter(MethodTree accessor, MethodTree getter) {
        return RecordDuplicatedGetterCheck.singleReturnStatementExpression(accessor).filter(expr -> RecordDuplicatedGetterCheck.isGetterInvocation(expr, getter.symbol())).isPresent();
    }

    private static Optional<ExpressionTree> singleReturnStatementExpression(MethodTree method) {
        return Optional.ofNullable(method.block()).filter(b -> b.body().size() == 1).map(b -> (StatementTree)b.body().get(0)).filter(s -> s.is(new Tree.Kind[]{Tree.Kind.RETURN_STATEMENT})).map(ReturnStatementTree.class::cast).map(ReturnStatementTree::expression).filter(Objects::nonNull);
    }

    private static boolean isComponent(ExpressionTree expression, Symbol.VariableSymbol component) {
        if (expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            return component.equals((Object)((IdentifierTree)expression).symbol());
        }
        if (expression.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            MemberSelectExpressionTree mset = (MemberSelectExpressionTree)expression;
            return ExpressionUtils.isThis((ExpressionTree)mset.expression()) && RecordDuplicatedGetterCheck.isComponent((ExpressionTree)mset.identifier(), component);
        }
        return false;
    }

    private static boolean isAccessorInvocation(ExpressionTree expression, Symbol.VariableSymbol component) {
        if (!expression.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            return false;
        }
        MethodInvocationTree mit = (MethodInvocationTree)expression;
        Symbol.MethodSymbol methodSymbol = mit.methodSymbol();
        return mit.arguments().isEmpty() && component.name().equals(methodSymbol.name()) && component.owner().equals((Object)methodSymbol.owner());
    }

    private static boolean isGetterInvocation(ExpressionTree expression, Symbol.MethodSymbol getter) {
        return expression.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION}) && getter.equals((Object)((MethodInvocationTree)expression).methodSymbol());
    }

    private static String issueMessage(MethodTree getter, Symbol.VariableSymbol component) {
        return String.format("Remove this getter '%s()' from record and override an existing one '%s()'.", getter.simpleName().name(), component.name());
    }

    private static List<Symbol.VariableSymbol> recordComponents(Symbol.TypeSymbol recordSymbol) {
        return recordSymbol.memberSymbols().stream().filter(Symbol::isVariableSymbol).map(Symbol.VariableSymbol.class::cast).toList();
    }

    private static Optional<MethodTree> findDeclaredMethod(Symbol.TypeSymbol recordSymbol, String methodName) {
        return recordSymbol.lookupSymbols(methodName).stream().filter(Symbol::isMethodSymbol).filter(Symbol::isPublic).map(Symbol.MethodSymbol.class::cast).filter(m -> m.parameterTypes().isEmpty()).map(Symbol.MethodSymbol::declaration).filter(Objects::nonNull).findFirst();
    }

    private static String upperCaseFirstCharacter(String string) {
        return Character.toUpperCase(string.charAt(0)) + string.substring(1);
    }
}

