/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S6905")
public class QueryOnlyRequiredFieldsCheck
extends IssuableSubscriptionVisitor {
    private static final MethodMatchers SQL_QUERY_METHODS = MethodMatchers.create().ofSubTypes(new String[]{"java.sql.Connection", "java.sql.Statement"}).names(new String[]{"prepareStatement", "prepareCall", "execute", "executeQuery"}).addParametersMatcher(types -> !types.isEmpty() && ((Type)types.get(0)).is("java.lang.String")).build();
    private static final Predicate<String> SELECT_FROM_REGEXP = Pattern.compile("select\\s+\\*\\s+from", 2).asPredicate();

    public List<Tree.Kind> nodesToVisit() {
        return List.of(Tree.Kind.METHOD_INVOCATION);
    }

    public void visitNode(Tree tree) {
        MethodInvocationTree mit = (MethodInvocationTree)tree;
        if (SQL_QUERY_METHODS.matches(mit)) {
            mit.arguments().stream().map(QueryOnlyRequiredFieldsCheck::extractQuery).filter(Objects::nonNull).filter(arg -> SELECT_FROM_REGEXP.test(arg.value())).forEach(arg -> this.reportIssue((Tree)arg, "Don't use the query \"SELECT *\"."));
        }
    }

    private static LiteralTree extractQuery(ExpressionTree expression) {
        switch (expression.kind()) {
            case STRING_LITERAL: {
                return (LiteralTree)expression;
            }
            case IDENTIFIER: {
                return Optional.of(expression).map(IdentifierTree.class::cast).map(IdentifierTree::symbol).map(Symbol::declaration).filter(VariableTree.class::isInstance).map(VariableTree.class::cast).map(VariableTree::initializer).filter(LiteralTree.class::isInstance).map(LiteralTree.class::cast).orElse(null);
            }
        }
        return null;
    }
}

