/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.AbstractPrintfChecker;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2275")
public class PrintfFailCheck
extends AbstractPrintfChecker {
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        boolean isMessageFormat = MESSAGE_FORMAT.matches(mit);
        if (isMessageFormat && !mit.methodSymbol().isStatic()) {
            return;
        }
        super.checkFormatting(mit, isMessageFormat);
    }

    @Override
    protected void handlePrintfFormat(MethodInvocationTree mit, String formatString, List<ExpressionTree> args) {
        List<String> params = this.getParameters(formatString, mit);
        PrintfFailCheck.cleanupLineSeparator(params);
        if (!params.isEmpty()) {
            if (this.checkArgumentNumber(mit, PrintfFailCheck.argIndexes(params).size(), args.size())) {
                return;
            }
            this.verifyParametersForErrors(mit, args, params);
        }
    }

    @Override
    protected void handleMessageFormat(MethodInvocationTree mit, String formatString, List<ExpressionTree> args) {
        String newFormatString = PrintfFailCheck.cleanupDoubleQuote(formatString);
        this.checkUnbalancedBraces(mit, newFormatString);
    }

    private void checkUnbalancedBraces(MethodInvocationTree mit, String formatString) {
        String withoutParam = MESSAGE_FORMAT_PATTERN.matcher(formatString).replaceAll("");
        int numberOpenBrace = 0;
        block4: for (int i = 0; i < withoutParam.length(); ++i) {
            char ch = withoutParam.charAt(i);
            switch (ch) {
                case '{': {
                    ++numberOpenBrace;
                    continue block4;
                }
                case '}': {
                    --numberOpenBrace;
                    continue block4;
                }
            }
        }
        if (numberOpenBrace > 0) {
            this.reportIssue((Tree)mit.arguments().get(0), "Single left curly braces \"{\" must be escaped.");
        }
    }

    @Override
    protected void handlePrintfFormatCatchingErrors(MethodInvocationTree mit, String formatString, List<ExpressionTree> args) {
    }

    @Override
    protected void handleOtherFormatTree(MethodInvocationTree mit, ExpressionTree formatTree, List<ExpressionTree> args) {
    }

    @Override
    protected void reportMissingPrevious(MethodInvocationTree mit) {
        this.reportIssue((Tree)mit, "The argument index '<' refers to the previous format specifier but there isn't one.");
    }
}

