/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Optional;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.ReassignmentFinder;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2695")
public class PreparedStatementAndResultSetCheck
extends AbstractMethodDetection {
    private static final String INT = "int";
    private static final String JAVA_SQL_RESULTSET = "java.sql.ResultSet";
    private static final MethodMatchers PREPARE_STATEMENT = MethodMatchers.create().ofTypes(new String[]{"java.sql.Connection"}).name(name -> name.startsWith("prepareStatement")).withAnyParameters().build();

    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofTypes(new String[]{"java.sql.PreparedStatement"}).name(name -> name.startsWith("set")).addParametersMatcher(new String[]{INT, "*"}).build(), MethodMatchers.create().ofTypes(new String[]{JAVA_SQL_RESULTSET}).name(name -> name.startsWith("get")).addParametersMatcher(new String[]{INT}).addParametersMatcher(new String[]{INT, "*"}).build()});
    }

    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        ExpressionTree firstArgument = (ExpressionTree)mit.arguments().get(0);
        Optional firstArgumentAsConstant = firstArgument.asConstant(Integer.class);
        if (!firstArgumentAsConstant.isPresent()) {
            return;
        }
        boolean isMethodFromJavaSqlResultSet = mit.methodSymbol().owner().type().is(JAVA_SQL_RESULTSET);
        int methodFirstArgumentValue = (Integer)firstArgumentAsConstant.get();
        if (isMethodFromJavaSqlResultSet && methodFirstArgumentValue == 0) {
            this.reportIssue((Tree)firstArgument, "ResultSet indices start at 1.");
        } else if (!isMethodFromJavaSqlResultSet) {
            if (methodFirstArgumentValue == 0) {
                this.reportIssue((Tree)firstArgument, "PreparedStatement indices start at 1.");
            } else {
                ExpressionTree preparedStatementReference = PreparedStatementAndResultSetCheck.getPreparedStatementReference(mit);
                Integer numberParameters = PreparedStatementAndResultSetCheck.getPreparedStatementNumberOfParameters(preparedStatementReference);
                if (numberParameters != null && methodFirstArgumentValue > numberParameters) {
                    this.reportIssue((Tree)firstArgument, "This \"PreparedStatement\" " + (String)(numberParameters == 0 ? "has no" : "only has " + numberParameters) + " parameters.");
                }
            }
        }
    }

    @CheckForNull
    private static ExpressionTree getPreparedStatementReference(MethodInvocationTree mit) {
        ExpressionTree methodSelect = mit.methodSelect();
        if (methodSelect.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            ExpressionTree expression = ((MemberSelectExpressionTree)methodSelect).expression();
            if (expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                Symbol referenceSymbol = ((IdentifierTree)expression).symbol();
                return ReassignmentFinder.getClosestReassignmentOrDeclarationExpression((Tree)mit, (Symbol)referenceSymbol);
            }
        }
        return null;
    }

    @CheckForNull
    private static Integer getPreparedStatementNumberOfParameters(@Nullable ExpressionTree tree) {
        Arguments arguments;
        if (tree != null && tree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION}) && !(arguments = ((MethodInvocationTree)tree).arguments()).isEmpty() && PREPARE_STATEMENT.matches((MethodInvocationTree)tree)) {
            ExpressionTree firstArgument = (ExpressionTree)arguments.get(0);
            return PreparedStatementAndResultSetCheck.getNumberQuery(firstArgument, (Tree)firstArgument);
        }
        return null;
    }

    @CheckForNull
    private static Integer getNumberQuery(ExpressionTree expression, Tree startingPointForReassignment) {
        ExpressionTree expr = ExpressionUtils.skipParentheses((ExpressionTree)expression);
        if (expr.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            return PreparedStatementAndResultSetCheck.handleVariableUsedAsQuery((IdentifierTree)expr, startingPointForReassignment);
        }
        if (expr.is(new Tree.Kind[]{Tree.Kind.PLUS})) {
            return PreparedStatementAndResultSetCheck.handleStringConcatenation((BinaryExpressionTree)expr, startingPointForReassignment);
        }
        return PreparedStatementAndResultSetCheck.countQuery(expr);
    }

    private static Integer handleVariableUsedAsQuery(IdentifierTree identifier, Tree startingPointForReassignment) {
        ExpressionTree lastAssignmentExpr = ReassignmentFinder.getClosestReassignmentOrDeclarationExpression((Tree)startingPointForReassignment, (Symbol)identifier.symbol());
        if (lastAssignmentExpr != null) {
            Tree lastAssignment = lastAssignmentExpr.parent();
            if (lastAssignment.is(new Tree.Kind[]{Tree.Kind.PLUS_ASSIGNMENT})) {
                return PreparedStatementAndResultSetCheck.zeroIfNull(PreparedStatementAndResultSetCheck.getNumberQuery(lastAssignmentExpr, lastAssignment)) + PreparedStatementAndResultSetCheck.zeroIfNull(PreparedStatementAndResultSetCheck.getNumberQuery(((AssignmentExpressionTree)lastAssignment).variable(), lastAssignment));
            }
            return PreparedStatementAndResultSetCheck.getNumberQuery(lastAssignmentExpr, lastAssignment);
        }
        return null;
    }

    private static Integer handleStringConcatenation(BinaryExpressionTree expr, Tree startingPointForReassignment) {
        Integer left = PreparedStatementAndResultSetCheck.getNumberQuery(expr.leftOperand(), startingPointForReassignment);
        Integer right = PreparedStatementAndResultSetCheck.getNumberQuery(expr.rightOperand(), startingPointForReassignment);
        return left == null && right == null ? null : Integer.valueOf(PreparedStatementAndResultSetCheck.zeroIfNull(left) + PreparedStatementAndResultSetCheck.zeroIfNull(right));
    }

    private static int zeroIfNull(@Nullable Integer intValue) {
        return intValue == null ? 0 : intValue;
    }

    @CheckForNull
    private static Integer countQuery(ExpressionTree expression) {
        return expression.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL}) ? Integer.valueOf(StringUtils.countMatches((CharSequence)((LiteralTree)expression).value(), (CharSequence)"?")) : null;
    }
}

