/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.QuickFixHelper;
import org.sonar.java.reporting.AnalyzerMessage;
import org.sonar.java.reporting.JavaQuickFix;
import org.sonar.java.reporting.JavaTextEdit;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ListTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;

@Rule(key="S6217")
public class OmitPermittedTypesCheck
extends IssuableSubscriptionVisitor {
    private static final String MESSAGE = "Remove this redundant permitted list.";
    private final List<ClassTree> sealedClassesInFile = new ArrayList<ClassTree>();
    private final Set<Type> typesDeclaredInFile = new HashSet<Type>();

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        if (classTree.permitsKeyword() != null) {
            this.sealedClassesInFile.add(classTree);
        }
        this.typesDeclaredInFile.add(classTree.symbol().type());
    }

    public void leaveFile(JavaFileScannerContext context) {
        for (ClassTree sealedClass : this.sealedClassesInFile) {
            ListTree permittedTypes = sealedClass.permittedTypes();
            if (!permittedTypes.stream().map(TypeTree::symbolType).allMatch(this.typesDeclaredInFile::contains)) continue;
            SyntaxToken permitsKeyword = sealedClass.permitsKeyword();
            QuickFixHelper.newIssue(context).forRule((JavaCheck)this).onTree((Tree)permitsKeyword).withMessage(MESSAGE).withSecondaries(permittedTypes.stream().map(t -> new JavaFileScannerContext.Location("Permitted type", (Tree)t)).toList()).withQuickFix(() -> OmitPermittedTypesCheck.getQuickFix(permitsKeyword, (ListTree<TypeTree>)permittedTypes)).report();
        }
        this.sealedClassesInFile.clear();
        this.typesDeclaredInFile.clear();
        super.leaveFile(context);
    }

    private static JavaQuickFix getQuickFix(SyntaxToken permitsKeyword, ListTree<TypeTree> typeTrees) {
        return JavaQuickFix.newQuickFix((String)"Remove permitted list").addTextEdit(new JavaTextEdit[]{JavaTextEdit.removeTextSpan((AnalyzerMessage.TextSpan)AnalyzerMessage.textSpanBetween((Tree)permitsKeyword, (boolean)true, (Tree)QuickFixHelper.nextToken(typeTrees), (boolean)false))}).build();
    }
}

