/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.QuickFixHelper;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.reporting.JavaQuickFix;
import org.sonar.java.reporting.JavaTextEdit;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2446")
public class NotifyCheck
extends AbstractMethodDetection {
    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.create().ofAnyType().names(new String[]{"notify"}).addWithoutParametersMatcher().build();
    }

    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        IdentifierTree methodName = ExpressionUtils.methodName((MethodInvocationTree)mit);
        QuickFixHelper.newIssue(this.context).forRule((JavaCheck)this).onTree((Tree)methodName).withMessage("\"notify\" may not wake up the appropriate thread.").withQuickFix(() -> JavaQuickFix.newQuickFix((String)"Replace with \"notifyAll()\"").addTextEdit(new JavaTextEdit[]{JavaTextEdit.replaceTree((Tree)methodName, (String)"notifyAll")}).build()).report();
    }
}

