/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.checks.helpers.MethodTreeUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1142")
public class MethodWithExcessiveReturnsCheck
extends IssuableSubscriptionVisitor {
    private static final String ISSUE_MESSAGE = "This method has %d returns, which is more than the %d allowed.";
    private static final int DEFAULT_MAX = 3;
    @RuleProperty(description="Maximum allowed return statements per method", defaultValue="3")
    public int max = 3;
    private final Map<Tree, List<Tree>> returnStatements = new HashMap<Tree, List<Tree>>();
    private final Deque<Tree> methodsOrLambdas = new LinkedList<Tree>();

    public void leaveFile(JavaFileScannerContext context) {
        this.returnStatements.clear();
        this.methodsOrLambdas.clear();
    }

    public List<Tree.Kind> nodesToVisit() {
        return List.of(Tree.Kind.RETURN_STATEMENT, Tree.Kind.METHOD, Tree.Kind.LAMBDA_EXPRESSION);
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.RETURN_STATEMENT})) {
            this.returnStatements.computeIfAbsent(this.methodsOrLambdas.peek(), k -> new LinkedList()).add(((ReturnStatementTree)tree).returnKeyword());
        } else {
            this.methodsOrLambdas.push(tree);
        }
    }

    public void leaveNode(Tree tree) {
        if (!tree.is(new Tree.Kind[]{Tree.Kind.RETURN_STATEMENT})) {
            MethodWithExcessiveReturnsCheck.reportTree(tree).ifPresent(reportTree -> this.report(tree, (Tree)reportTree));
            this.returnStatements.remove(tree);
            this.methodsOrLambdas.pop();
        }
    }

    private static Optional<Tree> reportTree(Tree methodOrLambda) {
        if (methodOrLambda.is(new Tree.Kind[]{Tree.Kind.LAMBDA_EXPRESSION})) {
            return Optional.of(((LambdaExpressionTree)methodOrLambda).arrowToken());
        }
        MethodTree method = (MethodTree)methodOrLambda;
        if (!MethodTreeUtils.isEqualsMethod(method)) {
            return Optional.of(method.simpleName());
        }
        return Optional.empty();
    }

    private void report(Tree currentTree, Tree reportTree) {
        List returns = this.returnStatements.getOrDefault(currentTree, Collections.emptyList());
        int count = returns.size();
        if (count > this.max) {
            String message = String.format(ISSUE_MESSAGE, count, this.max);
            List<JavaFileScannerContext.Location> secondaries = returns.stream().map(token -> new JavaFileScannerContext.Location("return", token)).toList();
            this.reportIssue(reportTree, message, secondaries, null);
        }
    }
}

