/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S6904")
public class JpaEagerFetchTypeCheck
extends IssuableSubscriptionVisitor {
    private static final Set<String> FETCH_TYPE_ENUMS = Set.of("jakarta.persistence.FetchType", "javax.persistence.FetchType");

    public List<Tree.Kind> nodesToVisit() {
        return List.of(Tree.Kind.ANNOTATION);
    }

    public void visitNode(Tree tree) {
        AnnotationTree at = (AnnotationTree)tree;
        at.arguments().stream().map(JpaEagerFetchTypeCheck::getEagerArgument).filter(Objects::nonNull).findAny().ifPresent(arg -> this.reportIssue((Tree)arg, "Use lazy fetching instead."));
    }

    @Nullable
    private static IdentifierTree getEagerArgument(ExpressionTree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT})) {
            IdentifierTree fetchType;
            AssignmentExpressionTree assignmentTree = (AssignmentExpressionTree)tree;
            ExpressionTree assignedExpr = assignmentTree.expression();
            if (assignedExpr.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
                fetchType = ((MemberSelectExpressionTree)assignedExpr).identifier();
            } else if (assignedExpr.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                fetchType = (IdentifierTree)assignedExpr;
            } else {
                return null;
            }
            if ("fetch".equals(ExpressionUtils.extractIdentifier((AssignmentExpressionTree)assignmentTree).name()) && "EAGER".equals(fetchType.name()) && FETCH_TYPE_ENUMS.contains(assignedExpr.symbolType().fullyQualifiedName())) {
                return fetchType;
            }
        }
        return null;
    }
}

