/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.ThrowStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

@Rule(key="S2272")
public class IteratorNextExceptionCheck
extends IssuableSubscriptionVisitor {
    private static final MethodMatchers NEXT_INVOCATION_MATCHER = MethodMatchers.create().ofSubTypes(new String[]{"java.util.Iterator"}).name(name -> name.startsWith("next") || name.startsWith("previous")).addWithoutParametersMatcher().build();

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        MethodTree methodTree = (MethodTree)tree;
        if (IteratorNextExceptionCheck.isIteratorNextMethod(methodTree.symbol()) && methodTree.block() != null) {
            NextMethodBodyVisitor visitor = new NextMethodBodyVisitor();
            visitor.methodsVisited.add(methodTree);
            tree.accept((TreeVisitor)visitor);
            if (!visitor.expectedExceptionIsThrown) {
                this.reportIssue((Tree)methodTree.simpleName(), "Add a \"NoSuchElementException\" for iteration beyond the end of the collection.");
            }
        }
    }

    private static boolean isIteratorNextMethod(Symbol.MethodSymbol symbol) {
        return "next".equals(symbol.name()) && symbol.parameterTypes().isEmpty() && IteratorNextExceptionCheck.isIterator(symbol.enclosingClass());
    }

    private static boolean isIterator(Symbol.TypeSymbol typeSymbol) {
        return typeSymbol.type().isSubtypeOf("java.util.Iterator");
    }

    private static class NextMethodBodyVisitor
    extends BaseTreeVisitor {
        private boolean expectedExceptionIsThrown = false;
        private final Set<MethodTree> methodsVisited = new HashSet<MethodTree>();

        private NextMethodBodyVisitor() {
        }

        public void visitThrowStatement(ThrowStatementTree throwStatementTree) {
            NewClassTree newClassTree;
            Type symbolType;
            ExpressionTree expression = throwStatementTree.expression();
            if (expression.is(new Tree.Kind[]{Tree.Kind.NEW_CLASS}) && ((symbolType = (newClassTree = (NewClassTree)expression).symbolType()).isSubtypeOf("java.util.NoSuchElementException") || symbolType.isUnknown())) {
                this.expectedExceptionIsThrown = true;
            }
            super.visitThrowStatement(throwStatementTree);
        }

        public void visitMethodInvocation(MethodInvocationTree methodInvocation) {
            if (NEXT_INVOCATION_MATCHER.matches(methodInvocation) || NextMethodBodyVisitor.throwsNoSuchElementException(methodInvocation)) {
                this.expectedExceptionIsThrown = true;
            } else {
                boolean canVisit;
                Symbol.MethodSymbol methodSymbol = methodInvocation.methodSymbol();
                MethodTree methodTree = methodSymbol.declaration();
                boolean bl = canVisit = methodTree != null && this.methodsVisited.add(methodTree);
                if (canVisit) {
                    this.scan((Tree)methodTree);
                }
            }
            super.visitMethodInvocation(methodInvocation);
        }

        private static boolean throwsNoSuchElementException(MethodInvocationTree methodInvocationTree) {
            Symbol.MethodSymbol symbol = methodInvocationTree.methodSymbol();
            if (symbol.isUnknown()) {
                return true;
            }
            return NextMethodBodyVisitor.throwsNoSuchElementException(symbol.thrownTypes());
        }

        private static boolean throwsNoSuchElementException(List<? extends Type> thrownTypes) {
            return thrownTypes.stream().anyMatch(t -> t.isSubtypeOf("java.util.NoSuchElementException") || t.isUnknown());
        }
    }
}

