/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.LiteralUtils;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S1075")
public class HardcodedURICheck
extends IssuableSubscriptionVisitor {
    private static final String JAVA_LANG_STRING = "java.lang.String";
    private static final MethodMatchers MATCHERS = MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofTypes(new String[]{"java.net.URI"}).constructor().addParametersMatcher(new String[]{"java.lang.String"}).build(), MethodMatchers.create().ofTypes(new String[]{"java.io.File"}).constructor().addParametersMatcher(new String[]{"java.lang.String"}).addParametersMatcher(new String[]{"*", "java.lang.String"}).build()});
    private static final String SCHEME = "[a-zA-Z][a-zA-Z\\+\\.\\-]+";
    private static final String FOLDER_NAME = "[^/?%*:\\\\|\"<>]+";
    private static final String URI_REGEX = String.format("^%s://.+", "[a-zA-Z][a-zA-Z\\+\\.\\-]+");
    private static final String LOCAL_URI = String.format("^(~/|/|//[\\w-]+/|%s:/)(%s/)*%s/?", "[a-zA-Z][a-zA-Z\\+\\.\\-]+", "[^/?%*:\\\\|\"<>]+", "[^/?%*:\\\\|\"<>]+");
    private static final String BACKSLASH_LOCAL_URI = String.format("^(~\\\\\\\\|\\\\\\\\\\\\\\\\[\\w-]+\\\\\\\\|%s:\\\\\\\\)(%s\\\\\\\\)*%s(\\\\\\\\)?", "[a-zA-Z][a-zA-Z\\+\\.\\-]+", "[^/?%*:\\\\|\"<>]+", "[^/?%*:\\\\|\"<>]+");
    private static final String DISK_URI = "^[A-Za-z]:(/|\\\\)";
    private static final Pattern URI_PATTERN = Pattern.compile(URI_REGEX + "|" + LOCAL_URI + "|^[A-Za-z]:(/|\\\\)|" + BACKSLASH_LOCAL_URI);
    private static final Pattern VARIABLE_NAME_PATTERN = Pattern.compile("filename|path", 2);
    private static final Pattern PATH_DELIMETERS_PATTERN = Pattern.compile("\"/\"|\"//\"|\"\\\\\\\\\"|\"\\\\\\\\\\\\\\\\\"");
    private static final Pattern RELATIVE_URI_PATTERN = Pattern.compile("^(/[\\w-+!*.]+){1,2}");
    private final Deque<AnnotationTree> annotationsStack = new ArrayDeque<AnnotationTree>();
    private final List<IdentifierData> identifiersUsedInAnnotations = new ArrayList<IdentifierData>();
    private final List<VariableData> hardCodedUri = new ArrayList<VariableData>();

    public void setContext(JavaFileScannerContext context) {
        super.setContext(context);
        this.annotationsStack.clear();
        this.identifiersUsedInAnnotations.clear();
        this.hardCodedUri.clear();
    }

    public void leaveFile(JavaFileScannerContext context) {
        HashSet<Symbol> idSymbols = new HashSet<Symbol>();
        HashSet<String> idNamesWithSemantic = new HashSet<String>();
        HashSet<String> idNamesWithoutSemantic = new HashSet<String>();
        for (IdentifierData i : this.identifiersUsedInAnnotations) {
            if (i.symbol().isUnknown()) {
                idNamesWithoutSemantic.add(i.identifier());
                continue;
            }
            idSymbols.add(i.symbol());
            idNamesWithSemantic.add(i.identifier());
        }
        for (VariableData v : this.hardCodedUri) {
            if (idNamesWithoutSemantic.contains(v.identifier()) || idNamesWithSemantic.contains(v.identifier()) && idSymbols.contains(v.symbol())) continue;
            this.reportHardcodedURI(v.initializer());
        }
    }

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.NEW_CLASS, Tree.Kind.VARIABLE, Tree.Kind.ASSIGNMENT, Tree.Kind.ANNOTATION, Tree.Kind.IDENTIFIER);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void visitNode(Tree tree) {
        if (tree instanceof NewClassTree) {
            NewClassTree classTree = (NewClassTree)tree;
            this.checkNewClassTree(classTree);
            return;
        }
        if (tree instanceof VariableTree) {
            VariableTree variableTree = (VariableTree)tree;
            this.checkVariable(variableTree);
            return;
        }
        if (tree instanceof AnnotationTree) {
            AnnotationTree annotationTree = (AnnotationTree)tree;
            this.annotationsStack.add(annotationTree);
            return;
        }
        if (tree instanceof IdentifierTree) {
            IdentifierTree identifier = (IdentifierTree)tree;
            if (!this.annotationsStack.isEmpty()) {
                this.identifiersUsedInAnnotations.add(new IdentifierData(identifier.symbol(), identifier.name()));
                return;
            }
        }
        if (!(tree instanceof AssignmentExpressionTree)) return;
        AssignmentExpressionTree assignment = (AssignmentExpressionTree)tree;
        this.checkAssignment(assignment);
    }

    public void leaveNode(Tree tree) {
        if (tree instanceof AnnotationTree) {
            this.annotationsStack.pop();
        }
    }

    private void checkNewClassTree(NewClassTree nct) {
        if (MATCHERS.matches(nct)) {
            nct.arguments().forEach(this::checkExpression);
        }
    }

    private void checkVariable(VariableTree tree) {
        ExpressionTree initializer = tree.initializer();
        if (!HardcodedURICheck.isFileNameVariable(tree.simpleName()) || initializer == null || !tree.modifiers().annotations().isEmpty()) {
            return;
        }
        String stringLiteral = HardcodedURICheck.stringLiteral(initializer);
        if (stringLiteral == null) {
            this.reportStringConcatenationWithPathDelimiter(initializer);
            return;
        }
        if (ModifiersUtils.hasAll((ModifiersTree)tree.modifiers(), (Modifier[])new Modifier[]{Modifier.STATIC, Modifier.FINAL}) && RELATIVE_URI_PATTERN.matcher(stringLiteral).matches()) {
            return;
        }
        if (HardcodedURICheck.isHardcodedURI(initializer)) {
            this.hardCodedUri.add(new VariableData(tree.symbol(), tree.simpleName().name(), initializer));
        }
    }

    private void checkAssignment(AssignmentExpressionTree tree) {
        if (HardcodedURICheck.isFileNameVariable(HardcodedURICheck.getVariableIdentifier(tree)) && !HardcodedURICheck.isPartOfAnnotation(tree)) {
            this.checkExpression(tree.expression());
        }
    }

    private static boolean isPartOfAnnotation(AssignmentExpressionTree tree) {
        for (Tree parent = tree.parent(); parent != null; parent = parent.parent()) {
            if (!parent.is(new Tree.Kind[]{Tree.Kind.ANNOTATION})) continue;
            return true;
        }
        return false;
    }

    private static boolean isFileNameVariable(@Nullable IdentifierTree variable) {
        return variable != null && VARIABLE_NAME_PATTERN.matcher(variable.name()).find();
    }

    private void checkExpression(ExpressionTree expr) {
        if (HardcodedURICheck.isHardcodedURI(expr)) {
            this.reportHardcodedURI(expr);
        } else {
            this.reportStringConcatenationWithPathDelimiter(expr);
        }
    }

    private static boolean isHardcodedURI(ExpressionTree expr) {
        String stringLiteral = HardcodedURICheck.stringLiteral(expr);
        return stringLiteral != null && !stringLiteral.contains("*") && !stringLiteral.contains("$") && URI_PATTERN.matcher(stringLiteral).find();
    }

    @Nullable
    private static String stringLiteral(ExpressionTree expr) {
        ExpressionTree unquoted = ExpressionUtils.skipParentheses((ExpressionTree)expr);
        if (unquoted instanceof LiteralTree) {
            LiteralTree literalTree = (LiteralTree)unquoted;
            if (literalTree.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL})) {
                return LiteralUtils.trimQuotes((String)literalTree.value());
            }
        }
        return null;
    }

    private void reportHardcodedURI(ExpressionTree hardcodedURI) {
        this.reportIssue((Tree)hardcodedURI, "Refactor your code to get this URI from a customizable parameter.");
    }

    private void reportStringConcatenationWithPathDelimiter(ExpressionTree expr) {
        expr.accept((TreeVisitor)new StringConcatenationVisitor());
    }

    @CheckForNull
    private static IdentifierTree getVariableIdentifier(AssignmentExpressionTree tree) {
        ExpressionTree variable = ExpressionUtils.skipParentheses((ExpressionTree)tree.variable());
        if (variable.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            return (IdentifierTree)variable;
        }
        if (variable.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            return ((MemberSelectExpressionTree)variable).identifier();
        }
        return null;
    }

    private record IdentifierData(Symbol symbol, String identifier) {
    }

    private record VariableData(Symbol symbol, String identifier, ExpressionTree initializer) {
    }

    private class StringConcatenationVisitor
    extends BaseTreeVisitor {
        private StringConcatenationVisitor() {
        }

        public void visitBinaryExpression(BinaryExpressionTree tree) {
            if (tree.is(new Tree.Kind[]{Tree.Kind.PLUS})) {
                this.checkPathDelimiter(tree.leftOperand());
                this.checkPathDelimiter(tree.rightOperand());
            }
            super.visitBinaryExpression(tree);
        }

        private void checkPathDelimiter(ExpressionTree expr) {
            ExpressionTree newExpr = ExpressionUtils.skipParentheses((ExpressionTree)expr);
            if (newExpr.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL}) && PATH_DELIMETERS_PATTERN.matcher(((LiteralTree)newExpr).value()).find()) {
                HardcodedURICheck.this.reportIssue((Tree)newExpr, "Remove this hard-coded path-delimiter.");
            }
        }
    }
}

