/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S4551")
public class EnumEqualCheck
extends AbstractMethodDetection {
    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.create().ofAnyType().names(new String[]{"equals"}).addParametersMatcher(new String[]{"java.lang.Object"}).build();
    }

    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        MemberSelectExpressionTree mse;
        if (mit.methodSelect().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT}) && (EnumEqualCheck.isEnum((mse = (MemberSelectExpressionTree)mit.methodSelect()).expression()) || EnumEqualCheck.isEnum((ExpressionTree)mit.arguments().get(0)))) {
            this.reportIssue((Tree)mse.identifier(), "Use \"==\" to perform this enum comparison instead of using \"equals\"");
        }
    }

    private static boolean isEnum(ExpressionTree exp) {
        return exp.symbolType().symbol().isEnum();
    }
}

