/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2658")
public class DynamicClassLoadCheck
extends AbstractMethodDetection {
    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofSubTypes(new String[]{"java.lang.Class"}).names(new String[]{"forName"}).withAnyParameters().build(), MethodMatchers.create().ofSubTypes(new String[]{"java.lang.ClassLoader"}).names(new String[]{"loadClass"}).withAnyParameters().build()});
    }

    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        String stringConstant = (String)ExpressionsHelper.getConstantValueAsString((ExpressionTree)((ExpressionTree)mit.arguments().get(0))).value();
        if (stringConstant == null) {
            this.reportIssue((Tree)ExpressionUtils.methodName((MethodInvocationTree)mit), "Remove this use of dynamic class loading.");
        }
    }
}

