/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.ast.visitors.PublicApiChecker;
import org.sonar.java.checks.helpers.DeprecatedCheckerHelper;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1133")
public class DeprecatedTagPresenceCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(PublicApiChecker.apiKinds());
    }

    public void visitNode(Tree tree) {
        if (DeprecatedTagPresenceCheck.hasDeprecatedAnnotation(tree) || DeprecatedCheckerHelper.hasJavadocDeprecatedTag(tree)) {
            this.reportIssue(DeprecatedCheckerHelper.reportTreeForDeprecatedTree(tree), "Do not forget to remove this deprecated code someday.");
        }
    }

    private static boolean hasDeprecatedAnnotation(Tree tree) {
        return DeprecatedCheckerHelper.deprecatedAnnotation(tree) != null;
    }
}

