/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.JavaVersionAwareVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2143")
public class DateAndTimesCheck
extends AbstractMethodDetection
implements JavaVersionAwareVisitor {
    private static final MethodMatchers METHOD_MATCHERS = MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofTypes(new String[]{"java.util.Calendar"}).names(new String[]{"getInstance"}).withAnyParameters().build(), MethodMatchers.create().ofTypes(new String[]{"java.util.Date"}).constructor().withAnyParameters().build()});

    protected MethodMatchers getMethodInvocationMatchers() {
        return METHOD_MATCHERS;
    }

    protected void onConstructorFound(NewClassTree newClassTree) {
        this.reportIssue((Tree)newClassTree);
    }

    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        this.reportIssue((Tree)mit);
    }

    private void reportIssue(Tree tree) {
        this.reportIssue(tree, "Use the Java 8 Date and Time API instead." + this.context.getJavaVersion().java8CompatibilityMessage());
    }

    public boolean isCompatibleWithJavaVersion(JavaVersion version) {
        return version.isJava8Compatible();
    }
}

