/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;

@Rule(key="S2157")
public class CloneableImplementingCloneCheck
extends IssuableSubscriptionVisitor {
    private static final MethodMatchers CLONE_MATCHER = MethodMatchers.create().ofAnyType().names(new String[]{"clone"}).addWithoutParametersMatcher().build();

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        Symbol.TypeSymbol classSymbol = classTree.symbol();
        if (CloneableImplementingCloneCheck.isCloneable(classTree) && !classSymbol.isAbstract() && !CloneableImplementingCloneCheck.declaresCloneMethod(classSymbol)) {
            this.reportIssue((Tree)classTree.simpleName(), "Add a \"clone()\" method to this class.");
        }
    }

    private static boolean declaresCloneMethod(Symbol.TypeSymbol classSymbol) {
        return classSymbol.lookupSymbols("clone").stream().anyMatch(arg_0 -> ((MethodMatchers)CLONE_MATCHER).matches(arg_0));
    }

    private static boolean isCloneable(ClassTree classTree) {
        return classTree.superInterfaces().stream().map(TypeTree::symbolType).anyMatch(t -> t.is("java.lang.Cloneable"));
    }
}

