/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

@Rule(key="S2388")
public class CallSuperMethodFromInnerClassCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.CLASS, Tree.Kind.INTERFACE);
    }

    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        Symbol.TypeSymbol classSymbol = classTree.symbol();
        if (classSymbol != null && CallSuperMethodFromInnerClassCheck.isInnerClass((Symbol)classSymbol) && !CallSuperMethodFromInnerClassCheck.extendsOuterClass(classSymbol)) {
            classTree.accept((TreeVisitor)new MethodInvocationVisitor(classSymbol));
        }
    }

    private static boolean isInnerClass(Symbol symbol) {
        return symbol.owner().isTypeSymbol();
    }

    private static boolean extendsOuterClass(Symbol.TypeSymbol classSymbol) {
        Type superType = classSymbol.superClass();
        return superType != null && superType.erasure().equals((Object)classSymbol.owner().type().erasure());
    }

    private class MethodInvocationVisitor
    extends BaseTreeVisitor {
        private final Symbol.TypeSymbol classSymbol;

        public MethodInvocationVisitor(Symbol.TypeSymbol classSymbol) {
            this.classSymbol = classSymbol;
        }

        public void visitMethodInvocation(MethodInvocationTree tree) {
            Symbol.MethodSymbol symbol = tree.methodSymbol();
            if (tree.methodSelect().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && this.isCallToSuperclassMethod((Symbol)symbol)) {
                String methodName = ((IdentifierTree)tree.methodSelect()).name();
                CallSuperMethodFromInnerClassCheck.this.reportIssue((Tree)ExpressionUtils.methodName((MethodInvocationTree)tree), "Prefix this call to \"" + methodName + "\" with \"super.\".");
            }
            super.visitMethodInvocation(tree);
        }

        private boolean isCallToSuperclassMethod(Symbol symbol) {
            return symbol.isMethodSymbol() && !this.isConstructor(symbol) && this.isInherited(symbol) && this.outerClassHasMethodWithSameName(symbol);
        }

        private boolean isConstructor(Symbol symbol) {
            return "<init>".equals(symbol.name());
        }

        private boolean isInherited(Symbol symbol) {
            Type methodOwnerType = symbol.owner().type().erasure();
            Type innerType = this.classSymbol.type().erasure();
            return !symbol.isStatic() && innerType.isSubtypeOf(methodOwnerType) && !this.classSymbol.owner().type().equals((Object)methodOwnerType) && !innerType.equals((Object)methodOwnerType);
        }

        private boolean outerClassHasMethodWithSameName(Symbol symbol) {
            return !((Symbol.TypeSymbol)this.classSymbol.owner()).lookupSymbols(symbol.name()).isEmpty();
        }
    }
}

