/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.model.JUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S3254")
public class AnnotationDefaultArgumentCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.ANNOTATION);
    }

    public void visitNode(Tree tree) {
        AnnotationTree annotationTree = (AnnotationTree)tree;
        Symbol.TypeSymbol annotationSymbol = annotationTree.symbolType().symbol();
        if (annotationSymbol.isUnknown()) {
            return;
        }
        Map<String, Object> defaultValueByName = annotationSymbol.memberSymbols().stream().filter(Symbol::isMethodSymbol).map(Symbol.MethodSymbol.class::cast).filter(s -> JUtils.defaultValue((Symbol.MethodSymbol)s) != null).collect(Collectors.toMap(Symbol::name, JUtils::defaultValue));
        Iterator iterator = annotationTree.arguments().iterator();
        while (iterator.hasNext()) {
            ExpressionTree argument;
            ExpressionTree valueSet = argument = (ExpressionTree)iterator.next();
            String paramName = "value";
            if (argument.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT})) {
                AssignmentExpressionTree assignmentTree = (AssignmentExpressionTree)argument;
                IdentifierTree nameTree = (IdentifierTree)assignmentTree.variable();
                paramName = nameTree.name();
                valueSet = assignmentTree.expression();
            }
            if (!AnnotationDefaultArgumentCheck.setValueIsSameAsDefaultValue(defaultValueByName.get(paramName), valueSet)) continue;
            this.reportIssue((Tree)argument, String.format("Remove this default value assigned to parameter \"%s\".", paramName));
        }
    }

    private static boolean setValueIsSameAsDefaultValue(@Nullable Object defaultValue, ExpressionTree valueSet) {
        Optional valueAsStringConstant = valueSet.asConstant(String.class);
        if (valueAsStringConstant.isPresent()) {
            return ((String)valueAsStringConstant.get()).equals(defaultValue);
        }
        Optional valueAsIntConstant = valueSet.asConstant(Integer.class);
        return valueAsIntConstant.map(integer -> integer.equals(defaultValue)).orElse(false);
    }
}

