/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import javax.annotation.CheckForNull;
import org.sonar.java.ast.visitors.PublicApiChecker;
import org.sonar.java.checks.helpers.DeprecatedCheckerHelper;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

public abstract class AbstractMissingDeprecatedChecker
extends IssuableSubscriptionVisitor {
    private static final Tree.Kind[] CLASS_KINDS = PublicApiChecker.classKinds();
    private final Deque<Boolean> classOrInterfaceIsDeprecated = new ArrayDeque<Boolean>();

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(PublicApiChecker.apiKinds());
    }

    public void visitNode(Tree tree) {
        boolean isLocalVar = tree.is(new Tree.Kind[]{Tree.Kind.VARIABLE}) && ((VariableTree)tree).symbol().isLocalVariable();
        AnnotationTree deprecatedAnnotation = DeprecatedCheckerHelper.deprecatedAnnotation(tree);
        boolean hasDeprecatedAnnotation = deprecatedAnnotation != null;
        boolean hasJavadocDeprecatedTag = DeprecatedCheckerHelper.hasJavadocDeprecatedTag(tree);
        if (this.currentClassNotDeprecated() && !isLocalVar) {
            this.handleDeprecatedElement(tree, deprecatedAnnotation, hasJavadocDeprecatedTag);
        }
        if (tree.is(CLASS_KINDS)) {
            this.classOrInterfaceIsDeprecated.push(hasDeprecatedAnnotation || hasJavadocDeprecatedTag);
        }
    }

    abstract void handleDeprecatedElement(Tree var1, @CheckForNull AnnotationTree var2, boolean var3);

    private boolean currentClassNotDeprecated() {
        return this.classOrInterfaceIsDeprecated.isEmpty() || this.classOrInterfaceIsDeprecated.peek() == false;
    }

    public void leaveNode(Tree tree) {
        if (tree.is(CLASS_KINDS)) {
            this.classOrInterfaceIsDeprecated.pop();
        }
    }
}

