/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.externalreport;

import java.io.File;
import java.io.FileInputStream;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.SonarRuntime;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.java.externalreport.CheckstyleXmlReportReader;
import org.sonar.java.externalreport.ExternalIssueUtils;
import org.sonarsource.analyzer.commons.ExternalReportProvider;
import org.sonarsource.analyzer.commons.ExternalRuleLoader;

public class CheckstyleSensor
implements Sensor {
    private static final Logger LOG = LoggerFactory.getLogger(CheckstyleSensor.class);
    private static final String LINTER_NAME = "Checkstyle";
    private static final String LANGUAGE_KEY = "java";
    public static final String REPORT_PROPERTY_KEY = "sonar.java.checkstyle.reportPaths";
    public static final String LINTER_KEY = "checkstyle";
    private final ExternalRuleLoader ruleLoader;

    public CheckstyleSensor(SonarRuntime sonarRuntime) {
        this.ruleLoader = new ExternalRuleLoader(LINTER_KEY, LINTER_NAME, "org/sonar/l10n/java/rules/checkstyle/rules.json", LANGUAGE_KEY, sonarRuntime);
    }

    public ExternalRuleLoader ruleLoader() {
        return this.ruleLoader;
    }

    public void describe(SensorDescriptor descriptor) {
        descriptor.onlyOnLanguage(LANGUAGE_KEY).onlyWhenConfiguration(conf -> conf.hasKey(REPORT_PROPERTY_KEY)).name("Import of Checkstyle issues");
    }

    public void execute(SensorContext context) {
        List reportFiles = ExternalReportProvider.getReportFiles((SensorContext)context, (String)REPORT_PROPERTY_KEY);
        reportFiles.forEach(report -> ExternalIssueUtils.importIfExist(LINTER_NAME, context, report, this::importReport));
    }

    private void importReport(File reportPath, SensorContext context) {
        try (FileInputStream in = new FileInputStream(reportPath);){
            LOG.info("Importing {}", (Object)reportPath);
            CheckstyleXmlReportReader.read(context, in, this::saveIssue);
        }
        catch (Exception e) {
            LOG.error("Failed to import external issues report: {}", (Object)reportPath, (Object)e);
        }
    }

    private void saveIssue(SensorContext context, InputFile inputFile, String key, String line, String message) {
        ExternalIssueUtils.saveIssue(context, this.ruleLoader, inputFile, LINTER_KEY, key, line, message);
    }
}

