/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.externalreport;

import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.SonarRuntime;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.java.externalreport.ExternalIssueUtils;
import org.sonar.java.externalreport.SpotBugsXmlReportReader;
import org.sonarsource.analyzer.commons.ExternalReportProvider;
import org.sonarsource.analyzer.commons.ExternalRuleLoader;

public class SpotBugsSensor
implements Sensor {
    private static final Logger LOG = LoggerFactory.getLogger(SpotBugsSensor.class);
    public static final String SPOTBUGS_KEY = "spotbugs";
    private static final String SPOTBUGS_NAME = "SpotBugs";
    public static final String FINDSECBUGS_KEY = "findsecbugs";
    private static final String FINDSECBUGS_NAME = "FindSecBugs";
    public static final String FBCONTRIB_KEY = "fbcontrib";
    private static final String FBCONTRIB_NAME = "fb-contrib";
    private static final String LANGUAGE_KEY = "java";
    public static final String REPORT_PROPERTY_KEY = "sonar.java.spotbugs.reportPaths";
    private final ExternalRuleLoader ruleLoader;
    private final ExternalRuleLoader findSecBugsLoader;
    private final ExternalRuleLoader fbContribLoader;

    public SpotBugsSensor(SonarRuntime sonarRuntime) {
        this.ruleLoader = new ExternalRuleLoader(SPOTBUGS_KEY, SPOTBUGS_NAME, "org/sonar/l10n/java/rules/spotbugs/spotbugs-rules.json", LANGUAGE_KEY, sonarRuntime);
        this.findSecBugsLoader = new ExternalRuleLoader(FINDSECBUGS_KEY, FINDSECBUGS_NAME, "org/sonar/l10n/java/rules/spotbugs/findsecbugs-rules.json", LANGUAGE_KEY, sonarRuntime);
        this.fbContribLoader = new ExternalRuleLoader(FBCONTRIB_KEY, FBCONTRIB_NAME, "org/sonar/l10n/java/rules/spotbugs/fbcontrib-rules.json", LANGUAGE_KEY, sonarRuntime);
    }

    public ExternalRuleLoader ruleLoader() {
        return this.ruleLoader;
    }

    public ExternalRuleLoader findSecBugsLoader() {
        return this.findSecBugsLoader;
    }

    public ExternalRuleLoader fbContribLoader() {
        return this.fbContribLoader;
    }

    public void describe(SensorDescriptor descriptor) {
        descriptor.onlyOnLanguage(LANGUAGE_KEY).onlyWhenConfiguration(conf -> conf.hasKey(REPORT_PROPERTY_KEY)).name("Import of SpotBugs issues");
    }

    public void execute(SensorContext context) {
        List reportFiles = ExternalReportProvider.getReportFiles((SensorContext)context, (String)REPORT_PROPERTY_KEY);
        reportFiles.forEach(report -> ExternalIssueUtils.importIfExist(SPOTBUGS_NAME, context, report, this::importReport));
    }

    private void importReport(File reportPath, SensorContext context) {
        try (FileInputStream in = new FileInputStream(reportPath);){
            LOG.info("Importing {}", (Object)reportPath);
            HashMap<String, ExternalRuleLoader> otherLoaders = new HashMap<String, ExternalRuleLoader>();
            otherLoaders.put(FINDSECBUGS_KEY, this.findSecBugsLoader);
            otherLoaders.put(FBCONTRIB_KEY, this.fbContribLoader);
            SpotBugsXmlReportReader.read(context, in, this.ruleLoader, otherLoaders);
        }
        catch (Exception e) {
            LOG.error("Failed to import external issues report: {}", (Object)reportPath, (Object)e);
        }
    }
}

