/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.externalreport;

import java.io.File;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.SonarRuntime;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.java.externalreport.ExternalIssueUtils;
import org.sonar.java.externalreport.PmdXmlReportReader;
import org.sonarsource.analyzer.commons.ExternalReportProvider;
import org.sonarsource.analyzer.commons.ExternalRuleLoader;

public class PmdSensor
implements Sensor {
    private static final Logger LOG = LoggerFactory.getLogger(PmdSensor.class);
    public static final String REPORT_PROPERTY_KEY = "sonar.java.pmd.reportPaths";
    public static final String LINTER_KEY = "pmd";
    private static final String LINTER_NAME = "PMD";
    private static final String LANGUAGE_KEY = "java";
    private final ExternalRuleLoader ruleLoader;

    public PmdSensor(SonarRuntime sonarRuntime) {
        this.ruleLoader = new ExternalRuleLoader(LINTER_KEY, LINTER_NAME, "org/sonar/l10n/java/rules/pmd/rules.json", LANGUAGE_KEY, sonarRuntime);
    }

    public ExternalRuleLoader ruleLoader() {
        return this.ruleLoader;
    }

    public void describe(SensorDescriptor descriptor) {
        descriptor.onlyWhenConfiguration(conf -> conf.hasKey(REPORT_PROPERTY_KEY)).onlyOnLanguage(LANGUAGE_KEY).name("Import of PMD issues");
    }

    public void execute(SensorContext context) {
        List reportFiles = ExternalReportProvider.getReportFiles((SensorContext)context, (String)REPORT_PROPERTY_KEY);
        reportFiles.forEach(report -> ExternalIssueUtils.importIfExist(LINTER_NAME, context, report, this::importReport));
    }

    private void importReport(File reportFile, SensorContext context) {
        try {
            LOG.info("Importing {}", (Object)reportFile);
            PmdXmlReportReader.read(context, reportFile, this.ruleLoader);
        }
        catch (Exception e) {
            LOG.error("Failed to import external issues report: {}", (Object)reportFile.getAbsolutePath(), (Object)e);
        }
    }
}

