/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.externalreport;

import java.io.File;
import java.util.function.BiConsumer;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.issue.NewExternalIssue;
import org.sonar.api.batch.sensor.issue.NewIssueLocation;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonarsource.analyzer.commons.ExternalRuleLoader;

public final class ExternalIssueUtils {
    private static final Logger LOG = Loggers.get(ExternalIssueUtils.class);

    private ExternalIssueUtils() {
    }

    public static void importIfExist(String linterName, SensorContext sensorContext, File reportFile, BiConsumer<File, SensorContext> importFunction) {
        if (!reportFile.exists()) {
            LOG.warn("{} report not found: {}", (Object)linterName, (Object)reportFile);
            return;
        }
        importFunction.accept(reportFile, sensorContext);
    }

    public static void saveIssue(SensorContext context, ExternalRuleLoader ruleLoader, InputFile inputFile, String engineId, String ruleId, String line, String message) {
        NewExternalIssue newExternalIssue = context.newExternalIssue();
        newExternalIssue.type(ruleLoader.ruleType(ruleId)).severity(ruleLoader.ruleSeverity(ruleId)).remediationEffortMinutes(ruleLoader.ruleConstantDebtMinutes(ruleId));
        NewIssueLocation primaryLocation = newExternalIssue.newLocation().message(message).on((InputComponent)inputFile);
        if (!line.isEmpty() && !line.equals("0")) {
            primaryLocation.at(inputFile.selectLine(Integer.parseInt(line)));
        }
        newExternalIssue.at(primaryLocation).engineId(engineId).ruleId(ruleId).save();
    }
}

