/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.externalreport;

import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.List;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.java.externalreport.ExternalIssueUtils;
import org.sonar.java.externalreport.SpotBugsXmlReportReader;
import org.sonarsource.analyzer.commons.ExternalReportProvider;
import org.sonarsource.analyzer.commons.ExternalRuleLoader;

public class SpotBugsSensor
implements Sensor {
    private static final Logger LOG = Loggers.get(SpotBugsSensor.class);
    public static final String SPOTBUGS_KEY = "spotbugs";
    private static final String SPOTBUGS_NAME = "SpotBugs";
    public static final String FINDSECBUGS_KEY = "findsecbugs";
    private static final String FINDSECBUGS_NAME = "FindSecBugs";
    public static final String FBCONTRIB_KEY = "fbcontrib";
    private static final String FBCONTRIB_NAME = "fb-contrib";
    private static final String LANGUAGE_KEY = "java";
    public static final String REPORT_PROPERTY_KEY = "sonar.java.spotbugs.reportPaths";
    public static final ExternalRuleLoader RULE_LOADER = new ExternalRuleLoader("spotbugs", "SpotBugs", "org/sonar/l10n/java/rules/spotbugs/spotbugs-rules.json", "java");
    public static final ExternalRuleLoader FINDSECBUGS_LOADER = new ExternalRuleLoader("findsecbugs", "FindSecBugs", "org/sonar/l10n/java/rules/spotbugs/findsecbugs-rules.json", "java");
    public static final ExternalRuleLoader FBCONTRIB_LOADER = new ExternalRuleLoader("fbcontrib", "fb-contrib", "org/sonar/l10n/java/rules/spotbugs/fbcontrib-rules.json", "java");

    public void describe(SensorDescriptor descriptor) {
        descriptor.onlyOnLanguage(LANGUAGE_KEY).onlyWhenConfiguration(conf -> conf.hasKey(REPORT_PROPERTY_KEY)).name("Import of SpotBugs issues");
    }

    public void execute(SensorContext context) {
        List reportFiles = ExternalReportProvider.getReportFiles((SensorContext)context, (String)REPORT_PROPERTY_KEY);
        reportFiles.forEach(report -> ExternalIssueUtils.importIfExist(SPOTBUGS_NAME, context, report, SpotBugsSensor::importReport));
    }

    private static void importReport(File reportPath, SensorContext context) {
        try (FileInputStream in = new FileInputStream(reportPath);){
            LOG.info("Importing {}", (Object)reportPath);
            HashMap<String, ExternalRuleLoader> otherLoaders = new HashMap<String, ExternalRuleLoader>();
            otherLoaders.put(FINDSECBUGS_KEY, FINDSECBUGS_LOADER);
            otherLoaders.put(FBCONTRIB_KEY, FBCONTRIB_LOADER);
            SpotBugsXmlReportReader.read(context, in, RULE_LOADER, otherLoaders);
        }
        catch (Exception e) {
            LOG.error("Failed to import external issues report: " + String.valueOf(reportPath), (Throwable)e);
        }
    }
}

