/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.externalreport;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.sonar.api.batch.fs.FilePredicates;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.java.externalreport.ExternalIssueUtils;
import org.sonarsource.analyzer.commons.ExternalRuleLoader;
import org.sonarsource.analyzer.commons.xml.SafetyFactory;

public class SpotBugsXmlReportReader {
    private static final Logger LOG = Loggers.get(SpotBugsXmlReportReader.class);
    private static final QName TYPE_ATTRIBUTE = new QName("type");
    private static final QName SOURCE_PATH_ATTRIBUTE = new QName("sourcepath");
    private static final QName START_ATTRIBUTE = new QName("start");
    private final SensorContext context;
    private final ExternalRuleLoader defaultRuleLoader;
    private final Map<String, ExternalRuleLoader> otherLoaders;
    private List<String> sourceDirs = new ArrayList<String>();
    private String bugInstanceType = "";
    private String bugInstanceLongMessage = "";
    private String sourceLinePath = "";
    private String sourceLineStart = "";
    private StringBuilder textBuilder = null;

    private SpotBugsXmlReportReader(SensorContext context, ExternalRuleLoader defaultRuleLoader, Map<String, ExternalRuleLoader> otherLoaders) {
        this.context = context;
        this.defaultRuleLoader = defaultRuleLoader;
        this.otherLoaders = otherLoaders;
    }

    static void read(SensorContext context, InputStream in, ExternalRuleLoader defaultRuleLoader, Map<String, ExternalRuleLoader> otherLoaders) throws XMLStreamException, IOException {
        new SpotBugsXmlReportReader(context, defaultRuleLoader, otherLoaders).read(in);
    }

    private void read(InputStream in) throws XMLStreamException, IOException {
        XMLEventReader reader = SafetyFactory.createXMLInputFactory().createXMLEventReader(in);
        LinkedList<String> elementStack = new LinkedList<String>();
        while (reader.hasNext()) {
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement()) {
                String elementName = event.asStartElement().getName().getLocalPart();
                if (elementStack.isEmpty() && !"BugCollection".equals(elementName)) {
                    throw new IOException("Unexpected document root '" + elementName + "' instead of 'BugCollection'.");
                }
                elementStack.add(elementName);
                this.onStartElement(SpotBugsXmlReportReader.xpath(elementStack), event.asStartElement());
                continue;
            }
            if (event.isEndElement()) {
                this.onEndElement(SpotBugsXmlReportReader.xpath(elementStack));
                elementStack.removeLast();
                continue;
            }
            if (!event.isCharacters() || this.textBuilder == null) continue;
            this.textBuilder.append(event.asCharacters().getData());
        }
    }

    private static String xpath(Deque<String> elementStack) {
        return String.join((CharSequence)"/", elementStack);
    }

    private void onStartElement(String xpath, StartElement element) {
        switch (xpath) {
            case "BugCollection/BugInstance": {
                this.bugInstanceType = SpotBugsXmlReportReader.getAttributeValue(element, TYPE_ATTRIBUTE);
                this.bugInstanceLongMessage = "";
                this.sourceLinePath = "";
                this.sourceLineStart = "";
                break;
            }
            case "BugCollection/BugInstance/SourceLine": {
                this.sourceLinePath = SpotBugsXmlReportReader.getAttributeValue(element, SOURCE_PATH_ATTRIBUTE);
                this.sourceLineStart = SpotBugsXmlReportReader.getAttributeValue(element, START_ATTRIBUTE);
                break;
            }
            case "BugCollection/BugInstance/LongMessage": 
            case "BugCollection/Project/SrcDir": {
                this.textBuilder = new StringBuilder();
                break;
            }
        }
    }

    private void onEndElement(String xpath) {
        switch (xpath) {
            case "BugCollection/BugInstance": {
                this.consumeBugInstance();
                break;
            }
            case "BugCollection/BugInstance/LongMessage": {
                if (this.textBuilder == null) break;
                this.bugInstanceLongMessage = this.textBuilder.toString();
                this.textBuilder = null;
                break;
            }
            case "BugCollection/Project/SrcDir": {
                if (this.textBuilder == null) break;
                this.sourceDirs.add(this.textBuilder.toString());
                this.textBuilder = null;
                break;
            }
        }
    }

    private void consumeBugInstance() {
        if (this.sourceDirs.isEmpty()) {
            LOG.debug("Unexpected missing 'BugCollection/Project/SrcDir/text()'.");
            return;
        }
        if (this.bugInstanceType.isEmpty()) {
            LOG.debug("Unexpected empty 'BugCollection/BugInstance/@type'.");
            return;
        }
        if (this.sourceLinePath.isEmpty()) {
            LOG.debug("Unexpected empty 'BugCollection/BugInstance/SourceLine/@sourcepath' for bug '{}'.", (Object)this.bugInstanceType);
            return;
        }
        if (this.bugInstanceLongMessage.isEmpty()) {
            LOG.debug("Unexpected empty 'BugCollection/BugInstance/LongMessage/text()' for bug '{}'", (Object)this.bugInstanceType);
            return;
        }
        InputFile inputFile = SpotBugsXmlReportReader.findInputFile(this.context, this.sourceDirs, this.sourceLinePath);
        if (inputFile == null) {
            LOG.warn("No input file found for '{}'. No SpotBugs issues will be imported on this file.", (Object)this.sourceLinePath);
            return;
        }
        String engineId = "spotbugs";
        ExternalRuleLoader ruleLoader = this.defaultRuleLoader;
        for (Map.Entry<String, ExternalRuleLoader> otherLoader : this.otherLoaders.entrySet()) {
            if (!otherLoader.getValue().ruleKeys().contains(this.bugInstanceType)) continue;
            ruleLoader = otherLoader.getValue();
            engineId = otherLoader.getKey();
        }
        ExternalIssueUtils.saveIssue(this.context, ruleLoader, inputFile, engineId, this.bugInstanceType, this.sourceLineStart, this.bugInstanceLongMessage);
    }

    private static String getAttributeValue(StartElement element, QName attributeName) {
        Attribute attribute = element.getAttributeByName(attributeName);
        return attribute != null ? attribute.getValue() : "";
    }

    private static InputFile findInputFile(SensorContext context, List<String> sourceDirs, String relativeLinuxPath) {
        FilePredicates predicates = context.fileSystem().predicates();
        InputFile inputFile = null;
        for (String sourceDir : sourceDirs) {
            File sourceFile = new File(sourceDir, relativeLinuxPath);
            inputFile = context.fileSystem().inputFile(predicates.hasPath(sourceFile.toString()));
            if (inputFile == null) continue;
            break;
        }
        return inputFile;
    }
}

