/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.externalreport;

import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.sonar.api.batch.fs.FilePredicates;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonarsource.analyzer.commons.xml.SafetyFactory;

class CheckstyleXmlReportReader {
    private static final Logger LOG = Loggers.get(CheckstyleXmlReportReader.class);
    private static final QName CHECKSTYLE = new QName("checkstyle");
    private static final QName FILE = new QName("file");
    private static final QName ERROR = new QName("error");
    private static final QName NAME = new QName("name");
    private static final QName SOURCE = new QName("source");
    private static final QName LINE = new QName("line");
    private static final QName MESSAGE = new QName("message");
    private static final String CHECKSTYLE_PREFIX = "com.puppycrawl.tools.checkstyle.checks.";
    private final SensorContext context;
    private final IssueConsumer consumer;
    private int level = 0;
    @Nullable
    private InputFile inputFile = null;

    private CheckstyleXmlReportReader(SensorContext context, IssueConsumer consumer) {
        this.context = context;
        this.consumer = consumer;
    }

    static void read(SensorContext context, InputStream in, IssueConsumer consumer) throws XMLStreamException, IOException {
        new CheckstyleXmlReportReader(context, consumer).read(in);
    }

    private void read(InputStream in) throws XMLStreamException, IOException {
        XMLEventReader reader = SafetyFactory.createXMLInputFactory().createXMLEventReader(in);
        while (reader.hasNext()) {
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement()) {
                ++this.level;
                this.onElement(event.asStartElement());
                continue;
            }
            if (!event.isEndElement()) continue;
            --this.level;
        }
    }

    private void onElement(StartElement element) throws IOException {
        if (this.level == 1 && !CHECKSTYLE.equals(element.getName())) {
            throw new IOException("Unexpected document root '" + element.getName().getLocalPart() + "' instead of 'checkstyle'.");
        }
        if (this.level == 2 && FILE.equals(element.getName())) {
            this.onFileElement(element);
        } else if (this.level == 3 && ERROR.equals(element.getName())) {
            this.onErrorElement(element);
        }
    }

    private void onFileElement(StartElement element) {
        String filePath = CheckstyleXmlReportReader.getAttributeValue(element, NAME);
        if (filePath.isEmpty()) {
            this.inputFile = null;
            return;
        }
        FilePredicates predicates = this.context.fileSystem().predicates();
        this.inputFile = this.context.fileSystem().inputFile(predicates.hasPath(filePath));
        if (this.inputFile == null) {
            LOG.warn("No input file found for '{}'. No checkstyle issues will be imported on this file.", (Object)filePath);
        }
    }

    private void onErrorElement(StartElement element) {
        if (this.inputFile == null) {
            return;
        }
        String source = CheckstyleXmlReportReader.getAttributeValue(element, SOURCE);
        String line = CheckstyleXmlReportReader.getAttributeValue(element, LINE);
        String message = CheckstyleXmlReportReader.getAttributeValue(element, MESSAGE);
        if (!source.startsWith(CHECKSTYLE_PREFIX)) {
            LOG.debug("Unexpected rule key without '{}' prefix: '{}'", (Object)CHECKSTYLE_PREFIX, (Object)source);
            return;
        }
        if (message.isEmpty()) {
            LOG.debug("Unexpected error without message for rule: '{}'", (Object)source);
            return;
        }
        String key = source.substring(CHECKSTYLE_PREFIX.length());
        this.consumer.onError(this.context, this.inputFile, key, line, message);
    }

    private static String getAttributeValue(StartElement element, QName attributeName) {
        Attribute attribute = element.getAttributeByName(attributeName);
        return attribute != null ? attribute.getValue() : "";
    }

    @FunctionalInterface
    static interface IssueConsumer {
        public void onError(SensorContext var1, InputFile var2, String var3, String var4, String var5);
    }
}

