/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.tree.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.terraform.api.tree.ExpressionTree;
import org.sonar.iac.terraform.api.tree.SyntaxToken;
import org.sonar.iac.terraform.api.tree.TemplateIfDirectiveTree;
import org.sonar.iac.terraform.api.tree.TerraformTree;
import org.sonar.iac.terraform.tree.impl.TerraformTreeImpl;

public class TemplateIfDirectiveTreeImpl
extends TerraformTreeImpl
implements TemplateIfDirectiveTree {
    private final IfPart ifPart;
    private final ElsePart elsePart;
    private final SyntaxToken endIfOpenToken;
    private final SyntaxToken endIfToken;
    private final SyntaxToken endIfCloseToken;

    public TemplateIfDirectiveTreeImpl(IfPart ifPart, @Nullable ElsePart elsePart, SyntaxToken endIfOpenToken, SyntaxToken endIfToken, SyntaxToken endIfCloseToken) {
        this.ifPart = ifPart;
        this.elsePart = elsePart;
        this.endIfOpenToken = endIfOpenToken;
        this.endIfToken = endIfToken;
        this.endIfCloseToken = endIfCloseToken;
    }

    @Override
    public ExpressionTree condition() {
        return this.ifPart.condition;
    }

    @Override
    public ExpressionTree trueExpression() {
        return this.ifPart.trueExpression;
    }

    @Override
    public ExpressionTree falseExpression() {
        if (this.elsePart == null) {
            return null;
        }
        return this.elsePart.falseExpression;
    }

    @Override
    public TerraformTree.Kind getKind() {
        return TerraformTree.Kind.TEMPLATE_DIRECTIVE_IF;
    }

    public List<Tree> children() {
        ArrayList<Tree> children = new ArrayList<Tree>(this.ifPart.children());
        if (this.elsePart != null) {
            children.addAll(this.elsePart.children());
        }
        children.add(this.endIfOpenToken);
        children.add(this.endIfToken);
        children.add(this.endIfCloseToken);
        return children;
    }

    public static class ElsePart
    extends TerraformTreeImpl {
        private final SyntaxToken elseOpenToken;
        private final SyntaxToken elseToken;
        private final SyntaxToken elseCloseToken;
        private final ExpressionTree falseExpression;

        public ElsePart(SyntaxToken elseOpenToken, SyntaxToken elseToken, SyntaxToken elseCloseToken, ExpressionTree falseExpression) {
            this.elseOpenToken = elseOpenToken;
            this.elseToken = elseToken;
            this.elseCloseToken = elseCloseToken;
            this.falseExpression = falseExpression;
        }

        @Override
        public TerraformTree.Kind getKind() {
            return null;
        }

        public List<Tree> children() {
            return Arrays.asList(this.elseOpenToken, this.elseToken, this.elseCloseToken, this.falseExpression);
        }
    }

    public static class IfPart
    extends TerraformTreeImpl {
        private final SyntaxToken ifOpenToken;
        private final SyntaxToken ifToken;
        private final ExpressionTree condition;
        private final SyntaxToken ifCloseToken;
        private final ExpressionTree trueExpression;

        public IfPart(SyntaxToken ifOpenToken, SyntaxToken ifToken, ExpressionTree condition, SyntaxToken ifCloseToken, ExpressionTree trueExpression) {
            this.ifOpenToken = ifOpenToken;
            this.ifToken = ifToken;
            this.condition = condition;
            this.ifCloseToken = ifCloseToken;
            this.trueExpression = trueExpression;
        }

        @Override
        public TerraformTree.Kind getKind() {
            return null;
        }

        public List<Tree> children() {
            return Arrays.asList(this.ifOpenToken, this.ifToken, this.condition, this.ifCloseToken, this.trueExpression);
        }
    }
}

