/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.tree.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.terraform.api.tree.ExpressionTree;
import org.sonar.iac.terraform.api.tree.FunctionCallTree;
import org.sonar.iac.terraform.api.tree.SeparatedTrees;
import org.sonar.iac.terraform.api.tree.SyntaxToken;
import org.sonar.iac.terraform.api.tree.TerraformTree;
import org.sonar.iac.terraform.tree.impl.SeparatedTreesImpl;
import org.sonar.iac.terraform.tree.impl.TerraformTreeImpl;

public class FunctionCallTreeImpl
extends TerraformTreeImpl
implements FunctionCallTree {
    private final SyntaxToken name;
    private final SyntaxToken openParenthesis;
    private final SeparatedTrees<ExpressionTree> arguments;
    private final SyntaxToken closeParenthesis;

    public FunctionCallTreeImpl(SyntaxToken name, SyntaxToken openParenthesis, @Nullable SeparatedTrees<ExpressionTree> arguments, SyntaxToken closeParenthesis) {
        this.name = name;
        this.openParenthesis = openParenthesis;
        this.arguments = arguments != null ? arguments : SeparatedTreesImpl.empty();
        this.closeParenthesis = closeParenthesis;
    }

    @Override
    public SyntaxToken name() {
        return this.name;
    }

    @Override
    public SeparatedTrees<ExpressionTree> arguments() {
        return this.arguments;
    }

    public List<Tree> children() {
        ArrayList<Tree> children = new ArrayList<Tree>(Arrays.asList(this.name, this.openParenthesis));
        children.addAll(this.arguments.treesAndSeparators());
        children.add(this.closeParenthesis);
        return children;
    }

    @Override
    public TerraformTree.Kind getKind() {
        return TerraformTree.Kind.FUNCTION_CALL;
    }
}

