/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.checks.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.checks.TextUtils;
import org.sonar.iac.terraform.api.tree.ExpressionTree;

public class ExpressionPredicate {
    private static ExpressionPredicate instance;
    private final Map<String, Pattern> compiledPatterns = new HashMap<String, Pattern>();

    private ExpressionPredicate() {
    }

    public static ExpressionPredicate getInstance() {
        if (instance == null) {
            instance = new ExpressionPredicate();
        }
        return instance;
    }

    private static Pattern pattern(String regex, int flags) {
        return ExpressionPredicate.getInstance().compiledPatterns.computeIfAbsent(String.format("pattern:%s,flags:%d", regex, flags), i -> Pattern.compile(regex, flags));
    }

    public static Predicate<ExpressionTree> notEqualTo(String expected) {
        return expression -> TextUtils.isValue((Tree)expression, (String)expected).isFalse();
    }

    public static Predicate<ExpressionTree> equalTo(String expected) {
        return expression -> TextUtils.isValue((Tree)expression, (String)expected).isTrue();
    }

    public static Predicate<ExpressionTree> matchesPattern(String pattern, int flags) {
        return expression -> TextUtils.matchesValue((Tree)expression, s -> ExpressionPredicate.pattern(pattern, flags).matcher((CharSequence)s).matches()).isTrue();
    }

    public static Predicate<ExpressionTree> matchesPattern(String pattern) {
        return ExpressionPredicate.matchesPattern(pattern, 2);
    }

    public static Predicate<ExpressionTree> isTrue() {
        return TextUtils::isValueTrue;
    }

    public static Predicate<ExpressionTree> isFalse() {
        return TextUtils::isValueFalse;
    }

    public static Predicate<ExpressionTree> lessThan(int other) {
        return expression -> TextUtils.getIntValue((Tree)expression).filter(current -> current < other).isPresent();
    }
}

