/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.checks.gcp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.checks.PropertyUtils;
import org.sonar.iac.common.extension.visitors.TreeContext;
import org.sonar.iac.common.extension.visitors.TreeVisitor;
import org.sonar.iac.terraform.api.tree.AttributeAccessTree;
import org.sonar.iac.terraform.api.tree.AttributeTree;
import org.sonar.iac.terraform.api.tree.BlockTree;
import org.sonar.iac.terraform.api.tree.ExpressionTree;
import org.sonar.iac.terraform.api.tree.TerraformTree;
import org.sonar.iac.terraform.checks.AbstractNewResourceCheck;
import org.sonar.iac.terraform.checks.utils.TerraformUtils;
import org.sonar.iac.terraform.symbols.ResourceSymbol;

class PolicyReferenceCollector
extends TreeVisitor<TreeContext> {
    private final Map<String, List<AttributeTree>> policyReferences = new HashMap<String, List<AttributeTree>>();
    private final Set<String> relevantResources;

    public PolicyReferenceCollector(Set<String> relevantResourceTypes) {
        this.relevantResources = relevantResourceTypes;
        this.register(BlockTree.class, (ctx, tree) -> {
            if (AbstractNewResourceCheck.isResource(tree) && this.relevantResources.contains(AbstractNewResourceCheck.resourceType(tree))) {
                this.collectReference((BlockTree)tree);
            }
        });
    }

    private void collectReference(BlockTree tree) {
        PropertyUtils.get((Tree)tree, (String)"policy_data", AttributeTree.class).filter(policyData -> policyData.value().is(TerraformTree.Kind.ATTRIBUTE_ACCESS)).ifPresent(policyData -> {
            String key = TerraformUtils.attributeAccessToString((AttributeAccessTree)policyData.value());
            this.policyReferences.computeIfAbsent(key, s -> new ArrayList()).add(policyData);
        });
    }

    private List<AttributeTree> getReferrersList(String policyDataName) {
        List<AttributeTree> res = this.policyReferences.get(String.format("data.google_iam_policy.%s.policy_data", policyDataName));
        return res == null ? Collections.emptyList() : res;
    }

    public void checkPolicy(ResourceSymbol data, Predicate<ExpressionTree> isSensitiveRole, String primaryMsg, String secondaryMsg) {
        List<AttributeTree> referrers = this.getReferrersList(data.name);
        if (referrers.isEmpty()) {
            return;
        }
        SecondaryLocation[] secondary = (SecondaryLocation[])referrers.stream().map(referrer -> new SecondaryLocation((HasTextRange)referrer, secondaryMsg)).toArray(SecondaryLocation[]::new);
        data.blocks("binding").forEach(binding -> binding.attribute("role").reportIf(isSensitiveRole, primaryMsg, secondary));
    }
}

