/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.checks.gcp;

import org.sonar.check.Rule;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.terraform.checks.AbstractNewResourceCheck;
import org.sonar.iac.terraform.checks.utils.ExpressionPredicate;
import org.sonar.iac.terraform.symbols.AttributeSymbol;
import org.sonar.iac.terraform.symbols.ResourceSymbol;

@Rule(key="S6410")
public class LoadBalancerSslPolicyCheck
extends AbstractNewResourceCheck {
    private static final String OMITTED_MESSAGE = "Set profile to disable support of weak cipher suites.";
    private static final String INVALID_VALUE_MESSAGE = "Change this code to disable support of weak cipher suites.";

    @Override
    protected void registerResourceConsumer() {
        this.register("google_compute_ssl_policy", (ResourceSymbol resource) -> ((AttributeSymbol)resource.attribute("profile").reportIfAbsent(OMITTED_MESSAGE, new SecondaryLocation[0])).reportIf(ExpressionPredicate.equalTo("COMPATIBLE").or(ExpressionPredicate.equalTo("MODERN")), INVALID_VALUE_MESSAGE, new SecondaryLocation[0]));
    }
}

