/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.checks.gcp;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.checks.PropertyUtils;
import org.sonar.iac.terraform.api.tree.AttributeTree;
import org.sonar.iac.terraform.api.tree.ObjectElementTree;
import org.sonar.iac.terraform.api.tree.ObjectTree;
import org.sonar.iac.terraform.checks.AbstractNewResourceCheck;
import org.sonar.iac.terraform.checks.utils.ExpressionPredicate;
import org.sonar.iac.terraform.symbols.AttributeSymbol;
import org.sonar.iac.terraform.symbols.ResourceSymbol;

@Rule(key="S6405")
public class ComputeInstanceSshKeysCheck
extends AbstractNewResourceCheck {
    private static final String MESSAGE = "Make sure that enabling project-wide SSH keys is safe here.";
    private static final String OMITTING_MESSAGE = "Omitting metadata.block-project-ssh-keys enables project-wide SSH keys. Make sure it is safe here.";

    @Override
    protected void registerResourceConsumer() {
        this.register(List.of("google_compute_instance", "google_compute_instance_template"), (ResourceSymbol resource) -> ComputeInstanceSshKeysCheck.checkMetadata(resource, true));
        this.register("google_compute_instance_from_template", (ResourceSymbol resource) -> ComputeInstanceSshKeysCheck.checkMetadata(resource, false));
    }

    private static void checkMetadata(ResourceSymbol resource, boolean reportOnMissing) {
        AttributeSymbol metadata = resource.attribute("metadata");
        if (metadata.isAbsent()) {
            if (reportOnMissing) {
                metadata.reportIfAbsent(OMITTING_MESSAGE, new SecondaryLocation[0]);
            }
            return;
        }
        if (!(((AttributeTree)metadata.tree).value() instanceof ObjectTree)) {
            return;
        }
        ObjectTree metadataObj = (ObjectTree)((AttributeTree)metadata.tree).value();
        PropertyUtils.get((Tree)metadataObj, (String)"block-project-ssh-keys", ObjectElementTree.class).ifPresentOrElse(sshKeysProperty -> {
            if (ExpressionPredicate.isFalse().test(sshKeysProperty.value())) {
                metadata.ctx.reportIssue((HasTextRange)sshKeysProperty, MESSAGE);
            }
        }, () -> {
            if (reportOnMissing) {
                metadata.ctx.reportIssue((HasTextRange)((AttributeTree)metadata.tree).key(), OMITTING_MESSAGE);
            }
        });
    }
}

