/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.checks.azure;

import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.common.api.tree.TextTree;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.checks.PropertyUtils;
import org.sonar.iac.common.checks.TextUtils;
import org.sonar.iac.terraform.api.tree.AttributeTree;
import org.sonar.iac.terraform.api.tree.BlockTree;
import org.sonar.iac.terraform.checks.AbstractResourceCheck;

@Rule(key="S6381")
public class HighPrivilegedRoleCheck
extends AbstractResourceCheck {
    private static final String MESSAGE = "Make sure that assigning the %s role is safe here.";
    private static final Set<String> HIGH_PRIVILEGED_ROLES = Set.of("Owner", "Contributor", "User Access Administrator");

    @Override
    protected void registerResourceChecks() {
        this.register(HighPrivilegedRoleCheck::checkRoleDefinitionName, "azurerm_role_assignment");
    }

    private static void checkRoleDefinitionName(CheckContext ctx, BlockTree resource) {
        PropertyUtils.get((Tree)resource, (String)"role_definition_name", AttributeTree.class).filter(attr -> TextUtils.matchesValue((Tree)attr.value(), HIGH_PRIVILEGED_ROLES::contains).isTrue()).ifPresent(attr -> ctx.reportIssue((HasTextRange)attr, String.format(MESSAGE, ((TextTree)attr.value()).value())));
    }
}

