/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.checks.aws;

import java.util.ArrayList;
import java.util.Optional;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.checks.PropertyUtils;
import org.sonar.iac.common.checks.TextUtils;
import org.sonar.iac.common.checks.policy.IpRestrictedAdminAccessCheckUtils;
import org.sonar.iac.terraform.api.tree.BlockTree;
import org.sonar.iac.terraform.api.tree.PrefixExpressionTree;
import org.sonar.iac.terraform.api.tree.TupleTree;
import org.sonar.iac.terraform.checks.AbstractResourceCheck;

public class AwsIpRestrictedAdminAccessCheckPart
extends AbstractResourceCheck {
    @Override
    protected void registerResourceChecks() {
        this.register(AwsIpRestrictedAdminAccessCheckPart::checkSecurityGroup, "aws_security_group");
    }

    private static void checkSecurityGroup(CheckContext ctx, BlockTree resource) {
        PropertyUtils.getAll((Tree)resource, (String)"ingress", BlockTree.class).forEach(i -> AwsIpRestrictedAdminAccessCheckPart.checkIngress(ctx, i));
    }

    private static void checkIngress(CheckContext ctx, BlockTree ingress) {
        Optional<TupleTree> defaultRouteCidrTree = AwsIpRestrictedAdminAccessCheckPart.getDefaultRouteCidr(ingress);
        if (defaultRouteCidrTree.isEmpty()) {
            return;
        }
        Optional ipProtocol = PropertyUtils.value((Tree)ingress, (String)"protocol");
        if (ipProtocol.isPresent() && AwsIpRestrictedAdminAccessCheckPart.isAllProtocols((Tree)ipProtocol.get())) {
            ctx.reportIssue((HasTextRange)defaultRouteCidrTree.get(), "Restrict IP addresses authorized to access administration services.", new SecondaryLocation((HasTextRange)ipProtocol.get(), "Related protocol setting."));
        } else if (ipProtocol.isPresent() && TextUtils.isValue((Tree)((Tree)ipProtocol.get()), (String)"tcp").isTrue()) {
            AwsIpRestrictedAdminAccessCheckPart.checkTcpPorts(ctx, ingress, defaultRouteCidrTree.get(), (Tree)ipProtocol.get());
        }
    }

    private static void checkTcpPorts(CheckContext ctx, Tree rule, Tree defaultRouteCidrTree, Tree ipProtocol) {
        Optional fromPort = PropertyUtils.value((Tree)rule, (String)"from_port");
        Optional toPort = PropertyUtils.value((Tree)rule, (String)"to_port");
        if (fromPort.isPresent() && toPort.isPresent() && AwsIpRestrictedAdminAccessCheckPart.rangeContainsSensitivePort((Tree)fromPort.get(), (Tree)toPort.get())) {
            ArrayList<SecondaryLocation> secondaryLocations = new ArrayList<SecondaryLocation>();
            secondaryLocations.add(new SecondaryLocation((HasTextRange)ipProtocol, "Related protocol setting."));
            secondaryLocations.add(new SecondaryLocation((HasTextRange)fromPort.get(), "Port range start."));
            secondaryLocations.add(new SecondaryLocation((HasTextRange)toPort.get(), "Port range end."));
            ctx.reportIssue((HasTextRange)defaultRouteCidrTree, "Restrict IP addresses authorized to access administration services.", secondaryLocations);
        }
    }

    private static boolean isAllProtocols(Tree tree) {
        return tree instanceof PrefixExpressionTree && "-".equals(((PrefixExpressionTree)tree).prefix().value()) && TextUtils.isValue((Tree)((PrefixExpressionTree)tree).expression(), (String)"1").isTrue();
    }

    private static boolean rangeContainsSensitivePort(Tree from, Tree to) {
        Optional fromIntValue = TextUtils.getIntValue((Tree)from);
        Optional toIntValue = TextUtils.getIntValue((Tree)to);
        return fromIntValue.isPresent() && toIntValue.isPresent() && ((Integer)fromIntValue.get() == 0 && (Integer)toIntValue.get() == 0 || IpRestrictedAdminAccessCheckUtils.rangeContainsSshOrRdpPort((int)((Integer)fromIntValue.get()), (int)((Integer)toIntValue.get())));
    }

    private static Optional<TupleTree> getDefaultRouteCidr(BlockTree ingress) {
        Optional<TupleTree> optCidrIp = PropertyUtils.value((Tree)ingress, (String)"cidr_blocks", TupleTree.class).filter(c -> AwsIpRestrictedAdminAccessCheckPart.containsValue(c, "0.0.0.0/0"));
        Optional<TupleTree> optCidrIpv6 = PropertyUtils.value((Tree)ingress, (String)"ipv6_cidr_blocks", TupleTree.class).filter(c -> AwsIpRestrictedAdminAccessCheckPart.containsValue(c, "::/0"));
        return optCidrIp.isPresent() ? optCidrIp : optCidrIpv6;
    }

    private static boolean containsValue(TupleTree tupleTree, String value) {
        return tupleTree.elements().trees().stream().anyMatch(t -> TextUtils.isValue((Tree)t, (String)value).isTrue());
    }
}

