/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.checks.aws;

import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.sonar.api.utils.Version;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.checkdsl.ContextualTree;
import org.sonar.iac.common.checks.PropertyUtils;
import org.sonar.iac.terraform.api.tree.AttributeTree;
import org.sonar.iac.terraform.api.tree.BlockTree;
import org.sonar.iac.terraform.api.tree.ExpressionTree;
import org.sonar.iac.terraform.api.tree.LiteralExprTree;
import org.sonar.iac.terraform.api.tree.TerraformTree;
import org.sonar.iac.terraform.checks.AbstractNewResourceCheck;
import org.sonar.iac.terraform.checks.utils.ExpressionPredicate;
import org.sonar.iac.terraform.plugin.TerraformProviders;
import org.sonar.iac.terraform.symbols.AttributeSymbol;
import org.sonar.iac.terraform.symbols.BlockSymbol;
import org.sonar.iac.terraform.symbols.ListSymbol;
import org.sonar.iac.terraform.symbols.ResourceSymbol;

public class AwsDisabledLoggingCheckPart
extends AbstractNewResourceCheck {
    private static final Version AWS_V_4 = Version.create((int)4, (int)0);

    @Override
    protected void registerResourceConsumer() {
        this.register("aws_s3_bucket", (ResourceSymbol resource) -> {
            BlockTree resourceBlock = (BlockTree)resource.tree;
            if (resource.provider(TerraformProviders.Provider.Identifier.AWS).hasVersionLowerThan(AWS_V_4) && !AwsDisabledLoggingCheckPart.isMaybeLoggingBucket(resourceBlock) && PropertyUtils.isMissing((Tree)resourceBlock, (String)"logging")) {
                resource.report(String.format("Omitting %s makes logs incomplete. Make sure it is safe here.", "logging or acl=\"log-delivery-write\""), new SecondaryLocation[0]);
            }
        });
        this.register("aws_api_gateway_stage", (ResourceSymbol resource) -> ((AttributeSymbol)resource.attribute("xray_tracing_enabled").reportIf(ExpressionPredicate.isFalse(), "Make sure that disabling logging is safe here.", new SecondaryLocation[0])).reportIfAbsent("Omitting %s makes logs incomplete. Make sure it is safe here.", new SecondaryLocation[0]));
        this.register(Set.of("aws_apigatewayv2_stage", "aws_api_gateway_stage"), (ResourceSymbol resource) -> resource.block("access_log_settings").reportIfAbsent("Omitting %s makes logs incomplete. Make sure it is safe here.", new SecondaryLocation[0]));
        this.register("aws_msk_cluster", (ResourceSymbol resource) -> {
            BlockSymbol brokerLogs = (BlockSymbol)((BlockSymbol)resource.block("logging_info").reportIfAbsent(String.format("Omitting %s makes logs incomplete. Make sure it is safe here.", "logging_info.broker_logs"), new SecondaryLocation[0])).block("broker_logs").reportIfAbsent("Omitting %s makes logs incomplete. Make sure it is safe here.", new SecondaryLocation[0]);
            Stream<AttributeSymbol> logSettings = Stream.of("cloudwatch_logs", "firehose", "s3").map(brokerLogs::block).filter(ContextualTree::isPresent).map(l -> l.attribute("enabled"));
            if (logSettings.noneMatch(l -> l.is(ExpressionPredicate.isFalse().negate()))) {
                brokerLogs.report(String.format("Omitting %s makes logs incomplete. Make sure it is safe here.", "cloudwatch_logs, firehose or s3"), new SecondaryLocation[0]);
            }
        });
        this.register("aws_neptune_cluster", (ResourceSymbol resource) -> ((ListSymbol)resource.list("enable_cloudwatch_logs_exports").reportIfEmpty("Make sure that disabling logging is safe here.", new SecondaryLocation[0])).reportIfAbsent("Omitting %s makes logs incomplete. Make sure it is safe here.", new SecondaryLocation[0]));
        this.register("aws_docdb_cluster", (ResourceSymbol resource) -> {
            ListSymbol exports = (ListSymbol)resource.list("enabled_cloudwatch_logs_exports").reportIfAbsent("Omitting %s makes logs incomplete. Make sure it is safe here.", new SecondaryLocation[0]);
            if (!exports.isByReference() && exports.getItemIf(ExpressionPredicate.equalTo("audit")).findAny().isEmpty()) {
                exports.report("Make sure that disabling logging is safe here.", new SecondaryLocation[0]);
            }
        });
        this.register("aws_mq_broker", (ResourceSymbol resource) -> {
            BlockSymbol logs = (BlockSymbol)resource.block("logs").reportIfAbsent(String.format("Omitting %s makes logs incomplete. Make sure it is safe here.", "logs.audit or logs.general"), new SecondaryLocation[0]);
            AttributeSymbol auditLog = logs.attribute("audit");
            AttributeSymbol generalLog = logs.attribute("general");
            if (auditLog.isAbsent() && generalLog.isAbsent() || auditLog.is(ExpressionPredicate.isFalse()) && generalLog.is(ExpressionPredicate.isFalse())) {
                logs.report("Make sure that disabling logging is safe here.", new SecondaryLocation[0]);
            }
        });
        this.register("aws_redshift_cluster", (ResourceSymbol resource) -> ((AttributeSymbol)((BlockSymbol)resource.block("logging").reportIfAbsent(String.format("Omitting %s makes logs incomplete. Make sure it is safe here.", "logging.enable"), new SecondaryLocation[0])).attribute("enable").reportIf(ExpressionPredicate.isFalse(), "Make sure that disabling logging is safe here.", new SecondaryLocation[0])).reportIfAbsent("Make sure that disabling logging is safe here.", new SecondaryLocation[0]));
        this.register("aws_globalaccelerator_accelerator", (ResourceSymbol resource) -> ((AttributeSymbol)((BlockSymbol)resource.block("attributes").reportIfAbsent(String.format("Omitting %s makes logs incomplete. Make sure it is safe here.", "attributes.flow_logs_enabled"), new SecondaryLocation[0])).attribute("flow_logs_enabled").reportIf(ExpressionPredicate.isFalse(), "Make sure that disabling logging is safe here.", new SecondaryLocation[0])).reportIfAbsent("Make sure that disabling logging is safe here.", new SecondaryLocation[0]));
        this.register("aws_elasticsearch_domain", (ResourceSymbol resource) -> resource.blocks("log_publishing_options").filter(block -> block.attribute("log_type").is(ExpressionPredicate.notEqualTo("AUDIT_LOGS").negate())).findFirst().ifPresentOrElse(auditLog -> auditLog.attribute("enabled").reportIf(ExpressionPredicate.isFalse(), "Make sure that disabling logging is safe here.", new SecondaryLocation[0]), () -> resource.report(String.format("Omitting %s makes logs incomplete. Make sure it is safe here.", "log_publishing_options of type \"AUDIT_LOGS\""), new SecondaryLocation[0])));
        this.register("aws_cloudfront_distribution", (ResourceSymbol resource) -> resource.block("logging_config").reportIfAbsent("Omitting %s makes logs incomplete. Make sure it is safe here.", new SecondaryLocation[0]));
        this.register("aws_lb", (ResourceSymbol resource) -> ((AttributeSymbol)((BlockSymbol)resource.block("access_logs").reportIfAbsent("Omitting %s makes logs incomplete. Make sure it is safe here.", new SecondaryLocation[0])).attribute("enabled").reportIf(ExpressionPredicate.isFalse(), "Make sure that disabling logging is safe here.", new SecondaryLocation[0])).reportIfAbsent("Make sure that disabling logging is safe here.", new SecondaryLocation[0]));
        this.register("aws_elb", (ResourceSymbol resource) -> ((BlockSymbol)resource.block("access_logs").reportIfAbsent("Omitting %s makes logs incomplete. Make sure it is safe here.", new SecondaryLocation[0])).attribute("enabled").reportIf(ExpressionPredicate.isFalse(), "Make sure that disabling logging is safe here.", new SecondaryLocation[0]));
    }

    private static boolean isMaybeLoggingBucket(BlockTree resource) {
        Optional acl = PropertyUtils.get((Tree)resource, (String)"acl", AttributeTree.class);
        if (acl.isEmpty()) {
            return false;
        }
        ExpressionTree aclValue = ((AttributeTree)acl.get()).value();
        if (aclValue.is(TerraformTree.Kind.STRING_LITERAL)) {
            return ((LiteralExprTree)aclValue).value().equals("log-delivery-write");
        }
        return true;
    }
}

