/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.checks;

import org.sonar.api.utils.Version;
import org.sonar.check.Rule;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.checks.PropertyUtils;
import org.sonar.iac.common.checks.TextUtils;
import org.sonar.iac.terraform.api.tree.AttributeTree;
import org.sonar.iac.terraform.api.tree.ObjectElementTree;
import org.sonar.iac.terraform.api.tree.TerraformTree;
import org.sonar.iac.terraform.checks.AbstractNewResourceCheck;
import org.sonar.iac.terraform.checks.utils.ExpressionPredicate;
import org.sonar.iac.terraform.plugin.TerraformProviders;
import org.sonar.iac.terraform.symbols.AttributeSymbol;
import org.sonar.iac.terraform.symbols.BlockSymbol;
import org.sonar.iac.terraform.symbols.ResourceSymbol;

@Rule(key="S6252")
public class UnversionedS3BucketCheck
extends AbstractNewResourceCheck {
    private static final String MESSAGE = "Make sure using %s S3 bucket is safe here.";
    private static final String OMITTING_MESSAGE = "Omitting \"versioning\" disables S3 bucket versioning. Make sure it is safe here.";
    private static final String UNVERSIONED_MSG = String.format("Make sure using %s S3 bucket is safe here.", "unversioned");
    private static final String SUSPENDED_MSG = String.format("Make sure using %s S3 bucket is safe here.", "suspended versioned");
    private static final String SECONDARY_MESSAGE = "Related bucket";
    private static final Version AWS_V_4 = Version.create((int)4, (int)0);

    @Override
    protected void registerResourceConsumer() {
        this.register("aws_s3_bucket", (ResourceSymbol resource) -> {
            SecondaryLocation secondaryLocation = resource.toSecondary(SECONDARY_MESSAGE);
            BlockSymbol versioningBlock = resource.block("versioning");
            ((AttributeSymbol)versioningBlock.attribute("enabled").reportIf(ExpressionPredicate.isFalse(), SUSPENDED_MSG, new SecondaryLocation[]{secondaryLocation})).reportIfAbsent(UNVERSIONED_MSG, new SecondaryLocation[]{secondaryLocation});
            AttributeSymbol versioningAttribute = resource.attribute("versioning");
            if (versioningAttribute.isPresent()) {
                UnversionedS3BucketCheck.checkVersionAttribute(versioningAttribute, secondaryLocation);
            }
            if (resource.provider(TerraformProviders.Provider.Identifier.AWS).hasVersionLowerThan(AWS_V_4) && versioningBlock.isAbsent() && versioningAttribute.isAbsent()) {
                resource.report(OMITTING_MESSAGE, new SecondaryLocation[0]);
            }
        });
        this.register("aws_s3_bucket_versioning", (ResourceSymbol resource) -> {
            SecondaryLocation secondary = resource.toSecondary(SECONDARY_MESSAGE);
            ((AttributeSymbol)resource.block("versioning_configuration").attribute("status").reportIf(ExpressionPredicate.equalTo("Disabled"), UNVERSIONED_MSG, new SecondaryLocation[]{secondary})).reportIf(ExpressionPredicate.equalTo("Suspended"), SUSPENDED_MSG, new SecondaryLocation[]{secondary});
        });
    }

    private static void checkVersionAttribute(AttributeSymbol attribute, SecondaryLocation secondaryLocation) {
        if (((AttributeTree)attribute.tree).value().is(TerraformTree.Kind.OBJECT)) {
            PropertyUtils.get((Tree)((AttributeTree)attribute.tree).value(), (String)"enabled", ObjectElementTree.class).ifPresentOrElse(enabled -> {
                if (TextUtils.isValueFalse((Tree)enabled.value())) {
                    attribute.ctx.reportIssue((HasTextRange)enabled, SUSPENDED_MSG, secondaryLocation);
                }
            }, () -> attribute.ctx.reportIssue((HasTextRange)((AttributeTree)attribute.tree).key(), UNVERSIONED_MSG, secondaryLocation));
        }
    }
}

