/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.checks;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.common.checks.policy.Policy;
import org.sonar.iac.common.checks.policy.PolicyValidator;
import org.sonar.iac.terraform.api.tree.BlockTree;
import org.sonar.iac.terraform.checks.AbstractResourceCheck;
import org.sonar.iac.terraform.checks.utils.PolicyUtils;

@Rule(key="S6304")
public class ResourceAccessPolicyCheck
extends AbstractResourceCheck {
    private static final String MESSAGE = "Make sure granting access to all resources is safe here.";
    private static final String EFFECT_MESSAGE = "Related effect";
    private static final String ACTION_MESSAGE = "Related action";

    @Override
    protected void checkResource(CheckContext ctx, BlockTree resource) {
        if (ResourceAccessPolicyCheck.isResource(resource, "aws_kms_key")) {
            return;
        }
        PolicyUtils.getPolicies(resource).forEach(policy -> ResourceAccessPolicyCheck.checkInsecurePolicy(ctx, policy));
    }

    private static void checkInsecurePolicy(CheckContext ctx, Policy policy) {
        PolicyValidator.findInsecureStatements((Policy)policy).forEach(statement -> ctx.reportIssue((HasTextRange)statement.resource, MESSAGE, List.of(new SecondaryLocation((HasTextRange)statement.effect, EFFECT_MESSAGE), new SecondaryLocation((HasTextRange)statement.action, ACTION_MESSAGE))));
    }
}

