/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.checks;

import org.sonar.api.utils.Version;
import org.sonar.check.Rule;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.terraform.checks.AbstractNewResourceCheck;
import org.sonar.iac.terraform.checks.utils.ExpressionPredicate;
import org.sonar.iac.terraform.plugin.TerraformProviders;
import org.sonar.iac.terraform.symbols.AttributeSymbol;
import org.sonar.iac.terraform.symbols.BlockSymbol;
import org.sonar.iac.terraform.symbols.ResourceSymbol;

@Rule(key="S6255")
public class DisabledMfaBucketDeletionCheck
extends AbstractNewResourceCheck {
    private static final String MESSAGE = "Make sure allowing object deletion without MFA is safe here.";
    private static final String MESSAGE_SECONDARY = "Related bucket";
    private static final Version AWS_V_4 = Version.create((int)4, (int)0);

    @Override
    protected void registerResourceConsumer() {
        this.register("aws_s3_bucket", (ResourceSymbol resource) -> {
            BlockSymbol versioning = resource.block("versioning");
            AttributeSymbol mfaDelete = (AttributeSymbol)versioning.attribute("mfa_delete").reportIf(ExpressionPredicate.isFalse(), MESSAGE, new SecondaryLocation[]{resource.toSecondary(MESSAGE_SECONDARY)});
            if (resource.provider(TerraformProviders.Provider.Identifier.AWS).hasVersionLowerThan(AWS_V_4) && mfaDelete.isAbsent()) {
                versioning.report(MESSAGE, new SecondaryLocation[]{resource.toSecondary(MESSAGE_SECONDARY)});
            }
        });
        this.register("aws_s3_bucket_versioning", (ResourceSymbol resource) -> {
            SecondaryLocation secondary = resource.toSecondary(MESSAGE_SECONDARY);
            ((AttributeSymbol)resource.block("versioning_configuration").attribute("mfa_delete").reportIf(ExpressionPredicate.equalTo("Disabled"), MESSAGE, new SecondaryLocation[]{secondary})).reportIfAbsent(MESSAGE, new SecondaryLocation[]{secondary});
        });
    }
}

