/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.checks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.InitContext;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.common.api.tree.PropertyTree;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.checks.PropertyUtils;
import org.sonar.iac.common.checks.TextUtils;
import org.sonar.iac.common.checks.policy.Policy;
import org.sonar.iac.terraform.api.tree.BlockTree;
import org.sonar.iac.terraform.api.tree.BodyTree;
import org.sonar.iac.terraform.api.tree.ObjectTree;
import org.sonar.iac.terraform.api.tree.StatementTree;
import org.sonar.iac.terraform.api.tree.TupleTree;
import org.sonar.iac.terraform.checks.AbstractResourceCheck;
import org.sonar.iac.terraform.checks.utils.PolicyUtils;

@Rule(key="S6270")
public class AnonymousAccessPolicyCheck
extends AbstractResourceCheck {
    private static final String MESSAGE = "Make sure granting public access is safe here.";
    private static final String SECONDARY_MESSAGE = "Related effect.";

    @Override
    public void initialize(InitContext init) {
        super.initialize(init);
        init.register(BlockTree.class, (ctx, tree) -> {
            if (!AnonymousAccessPolicyCheck.isResource(tree)) {
                AnonymousAccessPolicyCheck.checkInsecureStatementsOutsideResources(ctx, tree);
            }
        });
    }

    @Override
    protected void checkResource(CheckContext ctx, BlockTree resource) {
        PolicyUtils.getPolicies(resource).forEach(policy -> AnonymousAccessPolicyCheck.checkInsecurePolicy(ctx, policy));
    }

    private static void checkInsecurePolicy(CheckContext ctx, Policy policy) {
        PolicyValidator.findInsecureStatements(policy).forEach(statement -> ctx.reportIssue((HasTextRange)statement.principal, MESSAGE, new SecondaryLocation((HasTextRange)statement.effect, SECONDARY_MESSAGE)));
    }

    private static void checkInsecureStatementsOutsideResources(CheckContext ctx, BlockTree tree) {
        PolicyValidator.findInsecureStatements(tree).forEach(statement -> ctx.reportIssue((HasTextRange)statement.principal, MESSAGE, new SecondaryLocation((HasTextRange)statement.effect, SECONDARY_MESSAGE)));
    }

    private static class PolicyValidator {
        private PolicyValidator() {
        }

        public static Collection<InsecureStatement> findInsecureStatements(Policy policy) {
            ArrayList<InsecureStatement> result = new ArrayList<InsecureStatement>();
            for (Policy.Statement statement : policy.statement()) {
                statement.effect().filter(PolicyValidator::isAllowEffect).ifPresent(effect -> statement.principal().flatMap(PolicyValidator::findInsecurePrincipal).ifPresent(principal -> result.add(new InsecureStatement((Tree)principal, (Tree)effect))));
                statement.effect().filter(PolicyValidator::isDenyEffect).ifPresent(effect -> statement.notPrincipal().flatMap(PolicyValidator::findInsecurePrincipal).ifPresent(notPrincipal -> result.add(new InsecureStatement((Tree)notPrincipal, (Tree)effect))));
            }
            return result;
        }

        public static Collection<InsecureStatement> findInsecureStatements(BlockTree nonResource) {
            ArrayList<InsecureStatement> results = new ArrayList<InsecureStatement>();
            for (StatementTree statement : nonResource.properties()) {
                if (!"statement".equalsIgnoreCase(statement.key().value())) continue;
                PropertyUtils.value((Tree)statement, (String)"effect").filter(PolicyValidator::isAllowEffect).ifPresent(effect -> PropertyUtils.value((Tree)statement, (String)"principals", BodyTree.class).map(BodyTree::statements).filter(PolicyValidator::hasAwsType).flatMap(PolicyValidator::findInsecurePrincipal).ifPresent(principal -> results.add(new InsecureStatement((Tree)principal, (Tree)effect))));
                PropertyUtils.value((Tree)statement, (String)"effect").filter(PolicyValidator::isDenyEffect).ifPresent(effect -> PropertyUtils.value((Tree)statement, (String)"not_principals", BodyTree.class).map(BodyTree::statements).filter(PolicyValidator::hasAwsType).flatMap(PolicyValidator::findInsecurePrincipal).ifPresent(notPrincipals -> results.add(new InsecureStatement((Tree)notPrincipals, (Tree)effect))));
            }
            return results;
        }

        private static Optional<Tree> findInsecurePrincipal(Tree principal) {
            if (principal instanceof ObjectTree) {
                return PolicyValidator.findInsecurePrincipal((ObjectTree)principal);
            }
            if (principal instanceof TupleTree) {
                return PolicyValidator.findInsecurePrincipal((TupleTree)principal);
            }
            if (PolicyValidator.applyToAnyPrincipal(principal)) {
                return Optional.of(principal);
            }
            return Optional.empty();
        }

        private static Optional<Tree> findInsecurePrincipal(TupleTree tupleTree) {
            return tupleTree.elements().trees().stream().filter(PolicyValidator::applyToAnyPrincipal).map(Tree.class::cast).findAny();
        }

        private static Optional<Tree> findInsecurePrincipal(ObjectTree principal) {
            return PropertyUtils.get((Tree)principal, (String)"AWS").map(PropertyTree::value).flatMap(PolicyValidator::findInsecurePrincipal);
        }

        private static Optional<Tree> findInsecurePrincipal(List<StatementTree> statements) {
            return statements.stream().map(PolicyValidator::findInsercurePrincipal).filter(Optional::isPresent).map(Optional::get).findFirst();
        }

        private static Optional<Tree> findInsercurePrincipal(StatementTree principal) {
            if ("identifiers".equalsIgnoreCase(principal.key().value())) {
                return PolicyValidator.findInsecurePrincipal(principal.value());
            }
            return Optional.empty();
        }

        private static boolean applyToAnyPrincipal(Tree action) {
            return PolicyValidator.hasTextValue(action, "*");
        }

        private static boolean isAllowEffect(Tree effect) {
            return PolicyValidator.hasTextValue(effect, "Allow");
        }

        private static boolean isDenyEffect(Tree effect) {
            return PolicyValidator.hasTextValue(effect, "Deny");
        }

        private static boolean hasTextValue(Tree tree, String value) {
            return TextUtils.isValue((Tree)tree, (String)value).isTrue();
        }

        private static boolean hasAwsType(List<StatementTree> statements) {
            return statements.stream().filter(statement -> "type".equalsIgnoreCase(statement.key().value())).map(PropertyTree::value).anyMatch(value -> PolicyValidator.hasTextValue(value, "AWS"));
        }
    }

    private static class InsecureStatement {
        final Tree principal;
        final Tree effect;

        public InsecureStatement(Tree principal, Tree effect) {
            this.principal = principal;
            this.effect = effect;
        }
    }
}

