/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.dotnet.tests;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.List;
import java.util.Set;
import org.sonar.api.utils.WildcardPattern;

public class WildcardPatternFileProvider {
    public static final String CURRENT_FOLDER = ".";
    public static final String PARENT_FOLDER = "..";
    public static final String RECURSIVE_PATTERN = "**";
    public static final String ZERO_OR_MORE_PATTERN = "*";
    public static final String ANY_PATTERN = "?";
    private final File baseDir;
    private final String directorySeparator;

    public WildcardPatternFileProvider(File baseDir, String directorySeparator) {
        this.baseDir = baseDir;
        this.directorySeparator = directorySeparator;
    }

    public Set<File> listFiles(String pattern) {
        ImmutableList elements = ImmutableList.copyOf((Iterable)Splitter.on((String)this.directorySeparator).split((CharSequence)pattern));
        List<String> elementsTillFirstWildcard = WildcardPatternFileProvider.elementsTillFirstWildcard((List<String>)elements);
        String pathTillFirstWildcardElement = this.toPath(elementsTillFirstWildcard);
        File fileTillFirstWildcardElement = new File(pathTillFirstWildcardElement);
        File absoluteFileTillFirstWildcardElement = fileTillFirstWildcardElement.isAbsolute() ? fileTillFirstWildcardElement : new File(this.baseDir, pathTillFirstWildcardElement);
        List<String> wildcardElements = elements.subList(elementsTillFirstWildcard.size(), elements.size());
        if (wildcardElements.isEmpty()) {
            return absoluteFileTillFirstWildcardElement.exists() ? ImmutableSet.of((Object)absoluteFileTillFirstWildcardElement) : ImmutableSet.of();
        }
        WildcardPatternFileProvider.checkNoCurrentOrParentFolderAccess(wildcardElements);
        WildcardPattern wildcardPattern = WildcardPattern.create((String)this.toPath(wildcardElements), (String)this.directorySeparator);
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (File file : WildcardPatternFileProvider.listFiles(absoluteFileTillFirstWildcardElement)) {
            String relativePath = WildcardPatternFileProvider.relativize(absoluteFileTillFirstWildcardElement, file);
            if (!wildcardPattern.match(relativePath)) continue;
            builder.add((Object)file);
        }
        return builder.build();
    }

    private String toPath(List<String> elements) {
        return Joiner.on((String)this.directorySeparator).join(elements);
    }

    private static List<String> elementsTillFirstWildcard(List<String> elements) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String element : elements) {
            if (WildcardPatternFileProvider.containsWildcard(element)) break;
            builder.add((Object)element);
        }
        return builder.build();
    }

    private static void checkNoCurrentOrParentFolderAccess(List<String> elements) {
        for (String element : elements) {
            if (!WildcardPatternFileProvider.isCurrentOrParentFolder(element)) continue;
            throw new IllegalArgumentException("Cannot contain '.' or '..' after the first wildcard.");
        }
    }

    private static boolean containsWildcard(String element) {
        return RECURSIVE_PATTERN.equals(element) || element.contains(ZERO_OR_MORE_PATTERN) || element.contains(ANY_PATTERN);
    }

    private static boolean isCurrentOrParentFolder(String element) {
        return CURRENT_FOLDER.equals(element) || PARENT_FOLDER.equals(element);
    }

    private static Set<File> listFiles(File dir) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        WildcardPatternFileProvider.listFiles((ImmutableSet.Builder<File>)builder, dir);
        return builder.build();
    }

    private static void listFiles(ImmutableSet.Builder<File> builder, File dir) {
        Object[] files = dir.listFiles();
        if (files != null) {
            builder.add(files);
            for (Object file : files) {
                if (!((File)file).isDirectory()) continue;
                WildcardPatternFileProvider.listFiles(builder, (File)file);
            }
        }
    }

    private static String relativize(File parent, File file) {
        return file.getAbsolutePath().substring(parent.getAbsolutePath().length() + 1);
    }
}

