/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.dotnet.tests;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.io.IOException;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugins.dotnet.tests.Coverage;
import org.sonar.plugins.dotnet.tests.CoverageParser;
import org.sonar.plugins.dotnet.tests.XmlParserHelper;

public class VisualStudioCoverageXmlReportParser
implements CoverageParser {
    private static final Logger LOG = Loggers.get(VisualStudioCoverageXmlReportParser.class);

    @Override
    public void parse(File file, Coverage coverage) {
        LOG.info("Parsing the Visual Studio coverage XML report " + file.getAbsolutePath());
        new Parser(file, coverage).parse();
    }

    private static class Parser {
        private final File file;
        private final Multimap<Integer, Integer> coveredLines = HashMultimap.create();
        private final Multimap<Integer, Integer> uncoveredLines = HashMultimap.create();
        private final Coverage coverage;

        public Parser(File file, Coverage coverage) {
            this.file = file;
            this.coverage = coverage;
        }

        public void parse() {
            try (XmlParserHelper xmlParserHelper = new XmlParserHelper(this.file);){
                Parser.checkRootTag(xmlParserHelper);
                this.dispatchTags(xmlParserHelper);
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to close report", e);
            }
        }

        private void dispatchTags(XmlParserHelper xmlParserHelper) {
            String tagName;
            while ((tagName = xmlParserHelper.nextStartTag()) != null) {
                if ("module".equals(tagName)) {
                    this.handleModuleTag();
                    continue;
                }
                if ("range".equals(tagName)) {
                    this.handleRangeTag(xmlParserHelper);
                    continue;
                }
                if (!"source_file".equals(tagName)) continue;
                this.handleSourceFileTag(xmlParserHelper);
            }
        }

        private void handleModuleTag() {
            this.coveredLines.clear();
            this.uncoveredLines.clear();
        }

        private void handleRangeTag(XmlParserHelper xmlParserHelper) {
            int source = xmlParserHelper.getRequiredIntAttribute("source_id");
            String covered = xmlParserHelper.getRequiredAttribute("covered");
            int line = xmlParserHelper.getRequiredIntAttribute("start_line");
            if ("yes".equals(covered) || "partial".equals(covered)) {
                this.coveredLines.put((Object)source, (Object)line);
            } else if ("no".equals(covered)) {
                this.uncoveredLines.put((Object)source, (Object)line);
            } else {
                throw xmlParserHelper.parseError("Unsupported \"covered\" value \"" + covered + "\", expected one of \"yes\", \"partial\" or \"no\"");
            }
        }

        private void handleSourceFileTag(XmlParserHelper xmlParserHelper) {
            String canonicalPath;
            int id = xmlParserHelper.getRequiredIntAttribute("id");
            String path = xmlParserHelper.getRequiredAttribute("path");
            try {
                canonicalPath = new File(path).getCanonicalPath();
            }
            catch (IOException e) {
                LOG.debug("Skipping the import of Visual Studio XML code coverage for the invalid file path: " + path + " at line " + xmlParserHelper.stream().getLocation().getLineNumber(), (Object)e);
                return;
            }
            for (Integer line : this.coveredLines.get((Object)id)) {
                this.coverage.addHits(canonicalPath, line, 1);
            }
            for (Integer line : this.uncoveredLines.get((Object)id)) {
                this.coverage.addHits(canonicalPath, line, 0);
            }
        }

        private static void checkRootTag(XmlParserHelper xmlParserHelper) {
            xmlParserHelper.checkRootTag("results");
        }
    }
}

