/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.dotnet.tests;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugins.dotnet.tests.Coverage;
import org.sonar.plugins.dotnet.tests.CoverageParser;
import org.sonar.plugins.dotnet.tests.DotCoverReportParser;

public class DotCoverReportsAggregator
implements CoverageParser {
    private static final Logger LOG = Loggers.get(DotCoverReportsAggregator.class);
    private final DotCoverReportParser parser;

    public DotCoverReportsAggregator(DotCoverReportParser parser) {
        this.parser = parser;
    }

    @Override
    public void parse(File file, Coverage coverage) {
        LOG.info("Aggregating the HTML reports from " + file.getAbsolutePath());
        DotCoverReportsAggregator.checkIsHtml(file);
        String folderName = DotCoverReportsAggregator.extractFolderName(file);
        File folder = new File(file.getParentFile(), folderName + "/src");
        Preconditions.checkArgument((boolean)folder.exists(), (Object)("The following report dotCover report HTML sources folder cannot be found: " + folder.getAbsolutePath()));
        List<File> reportFiles = this.listReportFiles(folder);
        for (File reportFile : reportFiles) {
            if (DotCoverReportsAggregator.isExcluded(reportFile)) continue;
            this.parser.parse(reportFile, coverage);
        }
        Preconditions.checkArgument((!reportFiles.isEmpty() ? 1 : 0) != 0, (Object)("No dotCover report HTML source file found under: " + folder.getAbsolutePath()));
    }

    private List<File> listReportFiles(File folder) {
        Stream<Path> pathStream;
        try {
            pathStream = Files.list(folder.toPath());
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        return pathStream.map(Path::toFile).filter(f -> f.isFile() && f.getName().endsWith(".html")).collect(Collectors.toList());
    }

    private static void checkIsHtml(File file) {
        String contents;
        try {
            contents = new String(Files.readAllBytes(file.toPath()), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        Preconditions.checkArgument((boolean)contents.startsWith("<!DOCTYPE html>"), (Object)"Only dotCover HTML reports which start with \"<!DOCTYPE html>\" are supported.");
    }

    private static String extractFolderName(File file) {
        String name = file.getName();
        int lastDot = name.lastIndexOf(46);
        Preconditions.checkArgument((lastDot != -1 ? 1 : 0) != 0, (Object)("The following dotCover report name should have an extension: " + name));
        return name.substring(0, lastDot);
    }

    private static boolean isExcluded(File file) {
        return "nosource.html".equals(file.getName());
    }
}

