/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.dotnet.tests;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import java.io.File;
import org.sonar.api.batch.BatchSide;
import org.sonar.api.config.Settings;
import org.sonar.plugins.dotnet.tests.Coverage;
import org.sonar.plugins.dotnet.tests.CoverageCache;
import org.sonar.plugins.dotnet.tests.CoverageConfiguration;
import org.sonar.plugins.dotnet.tests.CoverageParser;
import org.sonar.plugins.dotnet.tests.DotCoverReportParser;
import org.sonar.plugins.dotnet.tests.DotCoverReportsAggregator;
import org.sonar.plugins.dotnet.tests.NCover3ReportParser;
import org.sonar.plugins.dotnet.tests.OpenCoverReportParser;
import org.sonar.plugins.dotnet.tests.VisualStudioCoverageXmlReportParser;
import org.sonar.plugins.dotnet.tests.WildcardPatternFileProvider;

@BatchSide
public class CoverageAggregator {
    private final CoverageConfiguration coverageConf;
    private final Settings settings;
    private final CoverageCache coverageCache;
    private final NCover3ReportParser ncover3ReportParser;
    private final OpenCoverReportParser openCoverReportParser;
    private final DotCoverReportsAggregator dotCoverReportsAggregator;
    private final VisualStudioCoverageXmlReportParser visualStudioCoverageXmlReportParser;

    public CoverageAggregator(CoverageConfiguration coverageConf, Settings settings) {
        this(coverageConf, settings, new CoverageCache(), new NCover3ReportParser(), new OpenCoverReportParser(), new DotCoverReportsAggregator(new DotCoverReportParser()), new VisualStudioCoverageXmlReportParser());
    }

    @VisibleForTesting
    public CoverageAggregator(CoverageConfiguration coverageConf, Settings settings, CoverageCache coverageCache, NCover3ReportParser ncover3ReportParser, OpenCoverReportParser openCoverReportParser, DotCoverReportsAggregator dotCoverReportsAggregator, VisualStudioCoverageXmlReportParser visualStudioCoverageXmlReportParser) {
        this.coverageConf = coverageConf;
        this.settings = settings;
        this.coverageCache = coverageCache;
        this.ncover3ReportParser = ncover3ReportParser;
        this.openCoverReportParser = openCoverReportParser;
        this.dotCoverReportsAggregator = dotCoverReportsAggregator;
        this.visualStudioCoverageXmlReportParser = visualStudioCoverageXmlReportParser;
    }

    public boolean hasCoverageProperty() {
        return this.hasNCover3ReportPaths() || this.hasOpenCoverReportPaths() || this.hasDotCoverReportPaths() || this.hasVisualStudioCoverageXmlReportPaths();
    }

    private boolean hasNCover3ReportPaths() {
        return this.settings.hasKey(this.coverageConf.ncover3PropertyKey());
    }

    private boolean hasOpenCoverReportPaths() {
        return this.settings.hasKey(this.coverageConf.openCoverPropertyKey());
    }

    private boolean hasDotCoverReportPaths() {
        return this.settings.hasKey(this.coverageConf.dotCoverPropertyKey());
    }

    private boolean hasVisualStudioCoverageXmlReportPaths() {
        return this.settings.hasKey(this.coverageConf.visualStudioCoverageXmlPropertyKey());
    }

    public Coverage aggregate(WildcardPatternFileProvider wildcardPatternFileProvider, Coverage coverage) {
        if (this.hasNCover3ReportPaths()) {
            this.aggregate(wildcardPatternFileProvider, this.settings.getString(this.coverageConf.ncover3PropertyKey()), this.ncover3ReportParser, coverage);
        }
        if (this.hasOpenCoverReportPaths()) {
            this.aggregate(wildcardPatternFileProvider, this.settings.getString(this.coverageConf.openCoverPropertyKey()), this.openCoverReportParser, coverage);
        }
        if (this.hasDotCoverReportPaths()) {
            this.aggregate(wildcardPatternFileProvider, this.settings.getString(this.coverageConf.dotCoverPropertyKey()), this.dotCoverReportsAggregator, coverage);
        }
        if (this.hasVisualStudioCoverageXmlReportPaths()) {
            this.aggregate(wildcardPatternFileProvider, this.settings.getString(this.coverageConf.visualStudioCoverageXmlPropertyKey()), this.visualStudioCoverageXmlReportParser, coverage);
        }
        return coverage;
    }

    private void aggregate(WildcardPatternFileProvider wildcardPatternFileProvider, String reportPaths, CoverageParser parser, Coverage aggregatedCoverage) {
        for (String reportPathPattern : Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)reportPaths)) {
            for (File reportFile : wildcardPatternFileProvider.listFiles(reportPathPattern)) {
                aggregatedCoverage.mergeWith(this.coverageCache.readCoverageFromCacheOrParse(parser, reportFile));
            }
        }
    }
}

