/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.dotnet.tests;

import java.io.File;
import java.io.IOException;
import javax.annotation.CheckForNull;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugins.dotnet.tests.UnitTestResults;
import org.sonar.plugins.dotnet.tests.UnitTestResultsParser;
import org.sonar.plugins.dotnet.tests.XmlParserHelper;

public class NUnitTestResultsFileParser
implements UnitTestResultsParser {
    private static final Logger LOG = Loggers.get(NUnitTestResultsFileParser.class);

    @Override
    public void parse(File file, UnitTestResults unitTestResults) {
        LOG.info("Parsing the NUnit Test Results file " + file.getAbsolutePath());
        new Parser(file, unitTestResults).parse();
    }

    private static class Parser {
        private final File file;
        private final UnitTestResults unitTestResults;

        public Parser(File file, UnitTestResults unitTestResults) {
            this.file = file;
            this.unitTestResults = unitTestResults;
        }

        public void parse() {
            try (XmlParserHelper xmlParserHelper = new XmlParserHelper(this.file);){
                Parser.checkRootTag(xmlParserHelper);
                this.handleTestResultsTag(xmlParserHelper);
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to close report", e);
            }
        }

        private static void checkRootTag(XmlParserHelper xmlParserHelper) {
            xmlParserHelper.checkRootTag("test-results");
        }

        private void handleTestResultsTag(XmlParserHelper xmlParserHelper) {
            int total = xmlParserHelper.getRequiredIntAttribute("total");
            int errors = xmlParserHelper.getRequiredIntAttribute("errors");
            int failures = xmlParserHelper.getRequiredIntAttribute("failures");
            int inconclusive = xmlParserHelper.getRequiredIntAttribute("inconclusive");
            int ignored = xmlParserHelper.getRequiredIntAttribute("ignored");
            int tests = total - inconclusive;
            int passed = total - errors - failures - inconclusive;
            int skipped = inconclusive + ignored;
            Double executionTime = Parser.readExecutionTimeFromDirectlyNestedTestSuiteTags(xmlParserHelper);
            this.unitTestResults.add(tests, passed, skipped, failures, errors, executionTime != null ? Long.valueOf((long)executionTime.doubleValue()) : null);
        }

        @CheckForNull
        private static Double readExecutionTimeFromDirectlyNestedTestSuiteTags(XmlParserHelper xmlParserHelper) {
            String tag;
            Double executionTime = null;
            int level = 0;
            while ((tag = xmlParserHelper.nextStartOrEndTag()) != null) {
                if ("<test-suite>".equals(tag)) {
                    Double time = xmlParserHelper.getDoubleAttribute("time");
                    if (++level != 1 || time == null) continue;
                    if (executionTime == null) {
                        executionTime = 0.0;
                    }
                    executionTime = executionTime + time * 1000.0;
                    continue;
                }
                if (!"</test-suite>".equals(tag)) continue;
                --level;
            }
            return executionTime;
        }
    }
}

