/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.dotnet.shared.plugins.sensors;

import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonarsource.dotnet.shared.plugins.ModuleConfiguration;
import org.sonarsource.dotnet.shared.plugins.PluginMetadata;
import org.sonarsource.dotnet.shared.plugins.ProtobufDataImporter;
import org.sonarsource.dotnet.shared.plugins.TelemetryCollector;
import org.sonarsource.dotnet.shared.plugins.protobuf.TelemetryImporter;

public class TelemetrySensor
implements Sensor {
    private static final Logger LOG = LoggerFactory.getLogger(TelemetrySensor.class);
    private final PluginMetadata pluginMetadata;
    private final ModuleConfiguration configuration;
    private final TelemetryCollector collector;

    public TelemetrySensor(TelemetryCollector collector, PluginMetadata pluginMetadata, ModuleConfiguration configuration) {
        this.pluginMetadata = pluginMetadata;
        this.configuration = configuration;
        this.collector = collector;
    }

    public void describe(SensorDescriptor descriptor) {
        String name = String.format("%s Telemetry", this.pluginMetadata.languageName());
        descriptor.name(name).onlyOnLanguage(this.pluginMetadata.languageKey());
    }

    public void execute(SensorContext context) {
        LOG.debug("Start importing metrics.");
        TelemetryImporter importer = new TelemetryImporter(this.collector);
        for (Path protobufDir : this.configuration.protobufReportPaths()) {
            ProtobufDataImporter.parseProtobuf(importer, protobufDir, "telemetry.pb");
        }
    }
}

