/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.dotnet.shared.plugins.sensors;

import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonarsource.dotnet.shared.plugins.MethodDeclarationsCollector;
import org.sonarsource.dotnet.shared.plugins.ModuleConfiguration;
import org.sonarsource.dotnet.shared.plugins.PluginMetadata;
import org.sonarsource.dotnet.shared.plugins.ProtobufDataImporter;
import org.sonarsource.dotnet.shared.plugins.protobuf.MethodDeclarationsImporter;

public class MethodDeclarationsSensor
implements Sensor {
    private static final Logger LOG = LoggerFactory.getLogger(MethodDeclarationsSensor.class);
    private final PluginMetadata pluginMetadata;
    private final ModuleConfiguration configuration;
    private final MethodDeclarationsCollector collector;

    public MethodDeclarationsSensor(MethodDeclarationsCollector collector, PluginMetadata pluginMetadata, ModuleConfiguration configuration) {
        this.pluginMetadata = pluginMetadata;
        this.configuration = configuration;
        this.collector = collector;
    }

    public void describe(SensorDescriptor descriptor) {
        String name = String.format("%s Method Declarations", this.pluginMetadata.languageName());
        descriptor.name(name);
    }

    public void execute(SensorContext context) {
        LOG.debug("Start importing method declarations.");
        MethodDeclarationsImporter importer = new MethodDeclarationsImporter(this.collector);
        for (Path protobufDir : this.configuration.protobufReportPaths()) {
            ProtobufDataImporter.parseProtobuf(importer, protobufDir, "test-method-declarations.pb");
        }
    }
}

