/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.dotnet.shared.plugins.sensors;

import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.FilePredicates;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.batch.sensor.cache.WriteCache;
import org.sonar.api.config.Configuration;
import org.sonar.api.scanner.ScannerSide;
import org.sonar.api.scanner.sensor.ProjectSensor;
import org.sonarsource.dotnet.shared.plugins.AbstractPropertyDefinitions;
import org.sonarsource.dotnet.shared.plugins.HashProvider;
import org.sonarsource.dotnet.shared.plugins.PluginMetadata;

@ScannerSide
public abstract class AbstractFileCacheSensor
implements ProjectSensor {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractFileCacheSensor.class);
    private final PluginMetadata metadata;
    private final HashProvider hashProvider;

    protected AbstractFileCacheSensor(PluginMetadata metadata, HashProvider hashProvider) {
        this.metadata = metadata;
        this.hashProvider = hashProvider;
    }

    protected String[] additionalSupportedExtensions() {
        return new String[0];
    }

    public void describe(SensorDescriptor descriptor) {
        descriptor.name(this.metadata.languageName() + " File Caching Sensor");
        descriptor.onlyOnLanguage(this.metadata.languageKey());
    }

    public void execute(SensorContext context) {
        Configuration configuration = context.config();
        if (configuration.get(AbstractPropertyDefinitions.getPullRequestBase()).isPresent()) {
            LOG.debug("Incremental PR analysis: Cache is not uploaded for pull requests.");
            return;
        }
        if (!context.isCacheEnabled()) {
            LOG.info("Incremental PR analysis: Analysis cache is disabled.");
            return;
        }
        Optional<URI> basePath = configuration.get(AbstractPropertyDefinitions.getPullRequestCacheBasePath()).map(x -> Paths.get(x, new String[0]).toUri());
        if (basePath.isEmpty()) {
            LOG.warn("Incremental PR analysis: Could not determine common base path, cache will not be computed. Consider setting 'sonar.projectBaseDir' property.");
            return;
        }
        LOG.debug("Incremental PR analysis: Preparing to upload file hashes.");
        FileSystem fileSystem = context.fileSystem();
        FilePredicates predicateFactory = fileSystem.predicates();
        List filePredicates = Arrays.stream(this.additionalSupportedExtensions()).map(arg_0 -> ((FilePredicates)predicateFactory).hasExtension(arg_0)).collect(Collectors.toList());
        filePredicates.add(predicateFactory.hasLanguage(this.metadata.languageKey()));
        fileSystem.inputFiles(predicateFactory.or(filePredicates)).forEach(inputFile -> {
            URI uri = inputFile.uri();
            String key = ((URI)basePath.get()).relativize(uri).getPath().replace('\\', '/');
            WriteCache next = context.nextCache();
            try {
                LOG.debug("Incremental PR analysis: Adding hash for '{}' to the cache.", (Object)key);
                next.write(key, this.hashProvider.computeHash(Path.of(uri)));
            }
            catch (Exception exception) {
                LOG.warn("Incremental PR analysis: An error occurred while computing the hash for " + key, (Throwable)exception);
            }
        });
    }
}

