/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.dotnet.shared.plugins;

import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.config.Configuration;
import org.sonar.api.config.PropertyDefinition;
import org.sonar.api.profiles.ProfileExporter;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.rules.ActiveRule;
import org.sonar.api.rules.ActiveRuleParam;
import org.sonar.api.server.rule.RulesDefinition;
import org.sonar.api.utils.ManifestUtils;
import org.sonarsource.dotnet.shared.plugins.PluginMetadata;

public class RoslynProfileExporter
extends ProfileExporter {
    private static final Logger LOG = LoggerFactory.getLogger(RoslynProfileExporter.class);
    private static final String ROSLYN_REPOSITORY_PREFIX = "roslyn.";
    private final PluginMetadata pluginMetadata;
    private final Configuration configuration;
    private final RulesDefinition[] rulesDefinitions;

    public RoslynProfileExporter(PluginMetadata pluginMetadata, Configuration configuration, RulesDefinition[] rulesDefinitions) {
        super(RoslynProfileExporter.profileKey(pluginMetadata), "Technical exporter for the MSBuild SonarQube Scanner");
        this.pluginMetadata = pluginMetadata;
        this.configuration = configuration;
        this.rulesDefinitions = rulesDefinitions;
        this.setSupportedLanguages(new String[]{pluginMetadata.languageKey()});
    }

    private static String sonarAnalyzerPartialRepoKey(PluginMetadata pluginMetadata) {
        return "sonaranalyzer-" + pluginMetadata.languageKey();
    }

    private static String profileKey(PluginMetadata pluginMetadata) {
        return "roslyn-" + pluginMetadata.languageKey();
    }

    public static List<PropertyDefinition> sonarLintRepositoryProperties(PluginMetadata metadata) {
        String version = RoslynProfileExporter.projectVersion();
        return Arrays.asList(PropertyDefinition.builder((String)RoslynProfileExporter.pluginKeyPropertyKey(RoslynProfileExporter.sonarAnalyzerPartialRepoKey(metadata))).defaultValue(metadata.pluginKey()).hidden().build(), PropertyDefinition.builder((String)RoslynProfileExporter.pluginVersionPropertyKey(RoslynProfileExporter.sonarAnalyzerPartialRepoKey(metadata))).defaultValue(version).hidden().build(), PropertyDefinition.builder((String)RoslynProfileExporter.staticResourceNamePropertyKey(RoslynProfileExporter.sonarAnalyzerPartialRepoKey(metadata))).defaultValue("SonarAnalyzer-" + metadata.pluginKey() + "-" + version + ".zip").hidden().build(), PropertyDefinition.builder((String)RoslynProfileExporter.analyzerIdPropertyKey(RoslynProfileExporter.sonarAnalyzerPartialRepoKey(metadata))).defaultValue(metadata.analyzerProjectName()).hidden().build(), PropertyDefinition.builder((String)RoslynProfileExporter.ruleNamespacePropertyKey(RoslynProfileExporter.sonarAnalyzerPartialRepoKey(metadata))).defaultValue(metadata.analyzerProjectName()).hidden().build(), PropertyDefinition.builder((String)RoslynProfileExporter.nugetPackageIdPropertyKey(RoslynProfileExporter.sonarAnalyzerPartialRepoKey(metadata))).defaultValue(metadata.analyzerProjectName()).hidden().build(), PropertyDefinition.builder((String)RoslynProfileExporter.nugetPackageVersionPropertyKey(RoslynProfileExporter.sonarAnalyzerPartialRepoKey(metadata))).defaultValue(version).hidden().build());
    }

    static String projectVersion() {
        List propertyValues = ManifestUtils.getPropertyValues((ClassLoader)RoslynProfileExporter.class.getClassLoader(), (String)"Plugin-Version");
        return propertyValues.isEmpty() ? "Version-N/A" : (String)propertyValues.iterator().next();
    }

    public void exportProfile(RulesProfile rulesProfile, Writer writer) {
        try {
            Map<String, List<RuleKey>> activeRoslynRulesByPartialRepoKey = RoslynProfileExporter.activeRoslynRulesByPartialRepoKey(this.pluginMetadata, rulesProfile.getActiveRules().stream().map(r -> RuleKey.of((String)r.getRepositoryKey(), (String)r.getRuleKey())).toList());
            RoslynProfileExporter.appendLine(writer, "<?xml version=\"1.0\" encoding=\"utf-8\"?>");
            RoslynProfileExporter.appendLine(writer, "<RoslynExportProfile Version=\"1.0\">");
            RoslynProfileExporter.appendLine(writer, "  <Configuration>");
            RoslynProfileExporter.appendLine(writer, "    <RuleSet Name=\"Rules for SonarQube\" Description=\"This rule set was automatically generated from SonarQube.\" ToolsVersion=\"14.0\">");
            for (Map.Entry<String, List<RuleKey>> partialRepoEntry : activeRoslynRulesByPartialRepoKey.entrySet()) {
                this.writeRepoRuleSet(partialRepoEntry.getKey(), (Collection<RuleKey>)partialRepoEntry.getValue(), writer);
            }
            RoslynProfileExporter.appendLine(writer, "    </RuleSet>");
            RoslynProfileExporter.appendLine(writer, "    <AdditionalFiles>");
            String sonarlintParameters = this.analysisSettings(rulesProfile);
            Base64.Encoder encoder = Base64.getEncoder();
            String base64 = new String(encoder.encode(sonarlintParameters.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
            RoslynProfileExporter.appendLine(writer, "      <AdditionalFile FileName=\"SonarLint.xml\">" + base64 + "</AdditionalFile>");
            RoslynProfileExporter.appendLine(writer, "    </AdditionalFiles>");
            RoslynProfileExporter.appendLine(writer, "  </Configuration>");
            RoslynProfileExporter.appendLine(writer, "  <Deployment>");
            RoslynProfileExporter.appendLine(writer, "    <Plugins>");
            for (String partialRepoKey : activeRoslynRulesByPartialRepoKey.keySet()) {
                String pluginKey = this.mandatoryPropertyValue(RoslynProfileExporter.pluginKeyPropertyKey(partialRepoKey));
                String pluginVersion = this.mandatoryPropertyValue(RoslynProfileExporter.pluginVersionPropertyKey(partialRepoKey));
                String staticResourceName = this.mandatoryPropertyValue(RoslynProfileExporter.staticResourceNamePropertyKey(partialRepoKey));
                RoslynProfileExporter.appendLine(writer, "      <Plugin Key=\"" + RoslynProfileExporter.escapeXml(pluginKey) + "\" Version=\"" + RoslynProfileExporter.escapeXml(pluginVersion) + "\" StaticResourceName=\"" + RoslynProfileExporter.escapeXml(staticResourceName) + "\" />");
            }
            RoslynProfileExporter.appendLine(writer, "    </Plugins>");
            RoslynProfileExporter.appendLine(writer, "    <NuGetPackages>");
            for (String partialRepoKey : activeRoslynRulesByPartialRepoKey.keySet()) {
                String packageId = this.mandatoryPropertyValue(RoslynProfileExporter.nugetPackageIdPropertyKey(partialRepoKey));
                String packageVersion = this.mandatoryPropertyValue(RoslynProfileExporter.nugetPackageVersionPropertyKey(partialRepoKey));
                RoslynProfileExporter.appendLine(writer, "      <NuGetPackage Id=\"" + RoslynProfileExporter.escapeXml(packageId) + "\" Version=\"" + RoslynProfileExporter.escapeXml(packageVersion) + "\" />");
            }
            RoslynProfileExporter.appendLine(writer, "    </NuGetPackages>");
            RoslynProfileExporter.appendLine(writer, "  </Deployment>");
            RoslynProfileExporter.appendLine(writer, "</RoslynExportProfile>");
        }
        catch (Exception e) {
            LOG.error(String.format("Error exporting profile '%s' for language '%s'", rulesProfile.getName(), rulesProfile.getLanguage()), (Throwable)e);
            throw e;
        }
    }

    private void writeRepoRuleSet(String partialRepoKey, Collection<RuleKey> ruleKeys, Writer writer) {
        String analyzerId = this.mandatoryPropertyValue(RoslynProfileExporter.analyzerIdPropertyKey(partialRepoKey));
        String ruleNamespace = this.mandatoryPropertyValue(RoslynProfileExporter.ruleNamespacePropertyKey(partialRepoKey));
        RoslynProfileExporter.appendLine(writer, "      <Rules AnalyzerId=\"" + RoslynProfileExporter.escapeXml(analyzerId) + "\" RuleNamespace=\"" + RoslynProfileExporter.escapeXml(ruleNamespace) + "\">");
        LinkedHashSet<String> activeRules = new LinkedHashSet<String>();
        String repositoryKey = null;
        for (RuleKey activeRuleKey : ruleKeys) {
            if (repositoryKey == null) {
                repositoryKey = activeRuleKey.repository();
            }
            String ruleKey = activeRuleKey.rule();
            activeRules.add(ruleKey);
            RoslynProfileExporter.appendLine(writer, "        <Rule Id=\"" + RoslynProfileExporter.escapeXml(ruleKey) + "\" Action=\"Warning\" />");
        }
        List<String> allRuleKeys = this.allRuleKeysByRepositoryKey(repositoryKey);
        for (String ruleKey : allRuleKeys) {
            if (activeRules.contains(ruleKey)) continue;
            RoslynProfileExporter.appendLine(writer, "        <Rule Id=\"" + RoslynProfileExporter.escapeXml(ruleKey) + "\" Action=\"None\" />");
        }
        RoslynProfileExporter.appendLine(writer, "      </Rules>");
    }

    private String analysisSettings(RulesProfile ruleProfile) {
        StringBuilder sb = new StringBuilder();
        RoslynProfileExporter.appendLine(sb, "<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        RoslynProfileExporter.appendLine(sb, "<AnalysisInput>");
        RoslynProfileExporter.appendLine(sb, "  <Rules>");
        for (ActiveRule activeRule : ruleProfile.getActiveRulesByRepository(this.pluginMetadata.repositoryKey())) {
            RoslynProfileExporter.appendLine(sb, "    <Rule>");
            RoslynProfileExporter.appendLine(sb, "      <Key>" + RoslynProfileExporter.escapeXml(activeRule.getRuleKey()) + "</Key>");
            RoslynProfileExporter.appendParameters(sb, RoslynProfileExporter.effectiveParameters(activeRule));
            RoslynProfileExporter.appendLine(sb, "    </Rule>");
        }
        RoslynProfileExporter.appendLine(sb, "  </Rules>");
        RoslynProfileExporter.appendLine(sb, "  <Files>");
        RoslynProfileExporter.appendLine(sb, "  </Files>");
        RoslynProfileExporter.appendLine(sb, "</AnalysisInput>");
        return sb.toString();
    }

    private static void appendParameters(StringBuilder sb, Map<String, String> parameters) {
        if (!parameters.isEmpty()) {
            RoslynProfileExporter.appendLine(sb, "      <Parameters>");
            for (Map.Entry<String, String> parameter : parameters.entrySet()) {
                RoslynProfileExporter.appendLine(sb, "        <Parameter>");
                RoslynProfileExporter.appendLine(sb, "          <Key>" + RoslynProfileExporter.escapeXml(parameter.getKey()) + "</Key>");
                RoslynProfileExporter.appendLine(sb, "          <Value>" + RoslynProfileExporter.escapeXml(parameter.getValue()) + "</Value>");
                RoslynProfileExporter.appendLine(sb, "        </Parameter>");
            }
            RoslynProfileExporter.appendLine(sb, "      </Parameters>");
        }
    }

    private static Map<String, String> effectiveParameters(ActiveRule activeRule) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (activeRule.getRule().getTemplate() != null) {
            result.put("RuleKey", activeRule.getRuleKey());
        }
        for (ActiveRuleParam param : activeRule.getActiveRuleParams()) {
            result.put(param.getKey(), param.getValue() == null ? "" : param.getValue());
        }
        for (ActiveRuleParam param : activeRule.getRule().getParams()) {
            if (result.containsKey(param.getKey())) continue;
            result.put(param.getKey(), param.getDefaultValue() == null ? "" : param.getDefaultValue());
        }
        return result;
    }

    public static Map<String, List<RuleKey>> activeRoslynRulesByPartialRepoKey(PluginMetadata pluginMetadata, Iterable<RuleKey> activeRules) {
        LinkedHashMap<String, List<RuleKey>> result = new LinkedHashMap<String, List<RuleKey>>();
        for (RuleKey activeRule : activeRules) {
            if (activeRule.repository().startsWith(ROSLYN_REPOSITORY_PREFIX)) {
                String pluginKey = activeRule.repository().substring(ROSLYN_REPOSITORY_PREFIX.length());
                result.putIfAbsent(pluginKey, new ArrayList());
                ((List)result.get(pluginKey)).add(activeRule);
                continue;
            }
            if (!pluginMetadata.repositoryKey().equals(activeRule.repository())) continue;
            result.putIfAbsent(RoslynProfileExporter.sonarAnalyzerPartialRepoKey(pluginMetadata), new ArrayList());
            ((List)result.get(RoslynProfileExporter.sonarAnalyzerPartialRepoKey(pluginMetadata))).add(activeRule);
        }
        return result;
    }

    private List<String> allRuleKeysByRepositoryKey(@Nullable String repositoryKey) {
        ArrayList<String> result = new ArrayList<String>();
        if (repositoryKey == null) {
            return result;
        }
        for (RulesDefinition rulesDefinition : this.rulesDefinitions) {
            RulesDefinition.Context context = new RulesDefinition.Context();
            rulesDefinition.define(context);
            RulesDefinition.Repository repo = context.repository(repositoryKey);
            if (repo == null) continue;
            for (RulesDefinition.Rule rule : repo.rules()) {
                result.add(rule.key());
            }
        }
        return result;
    }

    private String mandatoryPropertyValue(String propertyKey) {
        return (String)this.configuration.get(propertyKey).orElseThrow(() -> new IllegalStateException("The mandatory property \"" + propertyKey + "\" must be set by the Roslyn plugin."));
    }

    private static String pluginKeyPropertyKey(String partialRepoKey) {
        return partialRepoKey + ".pluginKey";
    }

    private static String pluginVersionPropertyKey(String partialRepoKey) {
        return partialRepoKey + ".pluginVersion";
    }

    private static String staticResourceNamePropertyKey(String partialRepoKey) {
        return partialRepoKey + ".staticResourceName";
    }

    private static String analyzerIdPropertyKey(String partialRepoKey) {
        return partialRepoKey + ".analyzerId";
    }

    private static String ruleNamespacePropertyKey(String partialRepoKey) {
        return partialRepoKey + ".ruleNamespace";
    }

    private static String nugetPackageIdPropertyKey(String partialRepoKey) {
        return partialRepoKey + ".nuget.packageId";
    }

    private static String nugetPackageVersionPropertyKey(String partialRepoKey) {
        return partialRepoKey + ".nuget.packageVersion";
    }

    private static String escapeXml(String str) {
        return str.replace("&", "&amp;").replace("\"", "&quot;").replace("'", "&apos;").replace("<", "&lt;").replace(">", "&gt;");
    }

    private static void appendLine(Writer writer, String line) {
        try {
            writer.write(line);
            writer.write("\r\n");
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private static void appendLine(StringBuilder sb, String line) {
        sb.append(line);
        sb.append("\r\n");
    }
}

