/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.dotnet.tests;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.config.Configuration;
import org.sonar.api.scanner.ScannerSide;
import org.sonar.plugins.dotnet.tests.NUnitTestResultsParser;
import org.sonar.plugins.dotnet.tests.UnitTestConfiguration;
import org.sonar.plugins.dotnet.tests.UnitTestResultParser;
import org.sonar.plugins.dotnet.tests.UnitTestResults;
import org.sonar.plugins.dotnet.tests.VisualStudioTestResultParser;
import org.sonar.plugins.dotnet.tests.WildcardPatternFileProvider;
import org.sonar.plugins.dotnet.tests.XUnitTestResultsParser;
import org.sonarsource.dotnet.protobuf.SonarAnalyzer;

@ScannerSide
public class UnitTestResultsAggregator {
    private static final Logger LOG = LoggerFactory.getLogger(UnitTestResultsAggregator.class);
    private final UnitTestConfiguration unitTestConf;
    private final Configuration configuration;
    private final VisualStudioTestResultParser visualStudioTestResultsParser;
    private final NUnitTestResultsParser nUnitTestResultsParser;
    private final XUnitTestResultsParser xunitTestResultsParser;

    public UnitTestResultsAggregator(UnitTestConfiguration unitTestConf, Configuration configuration) {
        this(unitTestConf, configuration, new VisualStudioTestResultParser(), new NUnitTestResultsParser(), new XUnitTestResultsParser());
    }

    UnitTestResultsAggregator(UnitTestConfiguration unitTestConf, Configuration configuration, VisualStudioTestResultParser visualStudioTestResultsFileParser, NUnitTestResultsParser nUnitTestResultsParser, XUnitTestResultsParser xunitTestResultsParser) {
        this.unitTestConf = unitTestConf;
        this.configuration = configuration;
        this.visualStudioTestResultsParser = visualStudioTestResultsFileParser;
        this.nUnitTestResultsParser = nUnitTestResultsParser;
        this.xunitTestResultsParser = xunitTestResultsParser;
    }

    boolean hasUnitTestResultsProperty(Predicate<String> hasKeyPredicate) {
        return this.hasVisualStudioTestResultsFile(hasKeyPredicate) || this.hasNUnitTestResultsFile(hasKeyPredicate) || this.hasXUnitTestResultsFile(hasKeyPredicate);
    }

    boolean hasUnitTestResultsProperty() {
        return this.hasUnitTestResultsProperty(arg_0 -> ((Configuration)this.configuration).hasKey(arg_0));
    }

    Map<String, UnitTestResults> aggregate(WildcardPatternFileProvider wildcardProvider, Collection<SonarAnalyzer.MethodDeclarationsInfo> methodDeclarations) {
        HashMap<String, String> fileMethodMap = UnitTestResultsAggregator.computeMethodFileMap(methodDeclarations);
        HashMap<String, UnitTestResults> results = new HashMap<String, UnitTestResults>();
        if (this.hasVisualStudioTestResultsFile(arg_0 -> ((Configuration)this.configuration).hasKey(arg_0))) {
            UnitTestResultsAggregator.aggregate(wildcardProvider, this.configuration.getStringArray(this.unitTestConf.visualStudioTestResultsFilePropertyKey()), this.visualStudioTestResultsParser, fileMethodMap, results);
        }
        if (this.hasXUnitTestResultsFile(arg_0 -> ((Configuration)this.configuration).hasKey(arg_0))) {
            UnitTestResultsAggregator.aggregate(wildcardProvider, this.configuration.getStringArray(this.unitTestConf.xunitTestResultsFilePropertyKey()), this.xunitTestResultsParser, fileMethodMap, results);
        }
        if (this.hasNUnitTestResultsFile(arg_0 -> ((Configuration)this.configuration).hasKey(arg_0))) {
            UnitTestResultsAggregator.aggregate(wildcardProvider, this.configuration.getStringArray(this.unitTestConf.nunitTestResultsFilePropertyKey()), this.nUnitTestResultsParser, fileMethodMap, results);
        }
        return results;
    }

    private static void aggregate(WildcardPatternFileProvider wildcardPatternFileProvider, String[] reportFilePatterns, UnitTestResultParser parser, Map<String, String> methodFileMap, Map<String, UnitTestResults> unitTestResultsMap) {
        for (String reportPathPattern : reportFilePatterns) {
            if (reportPathPattern.isEmpty()) continue;
            for (File reportFile : wildcardPatternFileProvider.listFiles(reportPathPattern)) {
                try {
                    parser.parse(reportFile, unitTestResultsMap, methodFileMap);
                }
                catch (Exception e) {
                    LOG.warn("Could not import unit test report '{}': {}", (Object)reportFile, (Object)e.getMessage());
                }
            }
        }
    }

    private boolean hasVisualStudioTestResultsFile(Predicate<String> hasKeyPredicate) {
        return hasKeyPredicate.test(this.unitTestConf.visualStudioTestResultsFilePropertyKey());
    }

    private boolean hasNUnitTestResultsFile(Predicate<String> hasKeyPredicate) {
        return hasKeyPredicate.test(this.unitTestConf.nunitTestResultsFilePropertyKey());
    }

    private boolean hasXUnitTestResultsFile(Predicate<String> hasKeyPredicate) {
        return hasKeyPredicate.test(this.unitTestConf.xunitTestResultsFilePropertyKey());
    }

    private static HashMap<String, String> computeMethodFileMap(Collection<SonarAnalyzer.MethodDeclarationsInfo> methodDeclarations) {
        HashMap<String, String> results = new HashMap<String, String>();
        for (SonarAnalyzer.MethodDeclarationsInfo methodDeclaration : methodDeclarations) {
            String assemblyName = methodDeclaration.getAssemblyName();
            String filePath = methodDeclaration.getFilePath();
            for (SonarAnalyzer.MethodDeclarationInfo methodDeclarationInfo : methodDeclaration.getMethodDeclarationsList()) {
                String key = assemblyName.trim() + "." + methodDeclarationInfo.getTypeName().trim() + "." + methodDeclarationInfo.getMethodName().trim();
                results.put(key, filePath);
            }
        }
        return results;
    }
}

