/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.web.page;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.sonar.api.web.page.Page;

public final class Context {
    private final Map<String, Page> pagesByPath = new HashMap<String, Page>();

    public Context addPage(Page page) {
        Page existingPageWithSameKey = this.pagesByPath.putIfAbsent(page.getKey(), page);
        if (existingPageWithSameKey != null) {
            throw new IllegalArgumentException(String.format("Page '%s' cannot be loaded. Another page with key '%s' already exists.", page.getName(), page.getKey()));
        }
        return this;
    }

    public Collection<Page> getPages() {
        return Collections.unmodifiableCollection(this.pagesByPath.values());
    }
}

