/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.bootstrap;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.CheckForNull;
import org.sonar.api.internal.apachecommons.lang3.ObjectUtils;
import org.sonar.api.internal.apachecommons.lang3.StringUtils;

@Deprecated
public class ProjectDefinition {
    public static final String SOURCES_PROPERTY = "sonar.sources";
    public static final String TESTS_PROPERTY = "sonar.tests";
    private static final char SEPARATOR = ',';
    private File baseDir;
    private File workDir;
    private Map<String, String> properties = new LinkedHashMap<String, String>();
    private ProjectDefinition parent = null;
    private List<ProjectDefinition> subProjects = new ArrayList<ProjectDefinition>();

    private ProjectDefinition(Properties p) {
        for (Map.Entry<Object, Object> entry : p.entrySet()) {
            this.properties.put(entry.getKey().toString(), entry.getValue().toString());
        }
    }

    public static ProjectDefinition create() {
        return new ProjectDefinition(new Properties());
    }

    public ProjectDefinition setBaseDir(File baseDir) {
        this.baseDir = baseDir;
        return this;
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public ProjectDefinition setWorkDir(File workDir) {
        this.workDir = workDir;
        return this;
    }

    public File getWorkDir() {
        return this.workDir;
    }

    public Map<String, String> properties() {
        return this.properties;
    }

    public ProjectDefinition setProperties(Map<String, String> properties) {
        this.properties.putAll(properties);
        return this;
    }

    public ProjectDefinition setProperty(String key, String value) {
        this.properties.put(key, value);
        return this;
    }

    public ProjectDefinition setKey(String key) {
        this.properties.put("sonar.projectKey", key);
        return this;
    }

    public ProjectDefinition setProjectVersion(String s) {
        this.properties.put("sonar.projectVersion", StringUtils.defaultString(s));
        return this;
    }

    public ProjectDefinition setName(String s) {
        this.properties.put("sonar.projectName", StringUtils.defaultString(s));
        return this;
    }

    public ProjectDefinition setDescription(String s) {
        this.properties.put("sonar.projectDescription", StringUtils.defaultString(s));
        return this;
    }

    public String getKey() {
        return this.properties.get("sonar.projectKey");
    }

    @Deprecated
    @CheckForNull
    public String getOriginalVersion() {
        return this.getOriginalProjectVersion();
    }

    @Deprecated
    public String getVersion() {
        return this.getProjectVersion();
    }

    @CheckForNull
    public String getOriginalProjectVersion() {
        return this.properties.get("sonar.projectVersion");
    }

    public String getProjectVersion() {
        String version = this.properties.get("sonar.projectVersion");
        if (StringUtils.isBlank(version)) {
            version = "not provided";
        }
        return version;
    }

    @CheckForNull
    public String getOriginalName() {
        return this.properties.get("sonar.projectName");
    }

    public String getName() {
        String name = this.properties.get("sonar.projectName");
        if (StringUtils.isBlank(name)) {
            name = this.getKey();
        }
        return name;
    }

    public String getDescription() {
        return this.properties.get("sonar.projectDescription");
    }

    private void appendProperty(String key, String value) {
        String current = ObjectUtils.defaultIfNull(this.properties.get(key), "");
        if (StringUtils.isBlank(current)) {
            this.properties.put(key, value);
        } else {
            this.properties.put(key, current + "," + value);
        }
    }

    public List<String> sources() {
        String sources = ObjectUtils.defaultIfNull(this.properties.get(SOURCES_PROPERTY), "");
        return ProjectDefinition.trim(StringUtils.split(sources, ','));
    }

    public ProjectDefinition addSources(String ... paths) {
        for (String path : paths) {
            this.appendProperty(SOURCES_PROPERTY, path);
        }
        return this;
    }

    public ProjectDefinition addSources(File ... fileOrDirs) {
        for (File fileOrDir : fileOrDirs) {
            this.addSources(fileOrDir.getAbsolutePath());
        }
        return this;
    }

    public ProjectDefinition resetSources() {
        this.properties.remove(SOURCES_PROPERTY);
        return this;
    }

    public ProjectDefinition setSources(String ... paths) {
        this.resetSources();
        return this.addSources(paths);
    }

    public ProjectDefinition setSources(File ... filesOrDirs) {
        this.resetSources();
        for (File fileOrDir : filesOrDirs) {
            this.addSources(fileOrDir.getAbsolutePath());
        }
        return this;
    }

    public List<String> tests() {
        String sources = ObjectUtils.defaultIfNull(this.properties.get(TESTS_PROPERTY), "");
        return ProjectDefinition.trim(StringUtils.split(sources, ','));
    }

    public ProjectDefinition addTests(String ... paths) {
        for (String path : paths) {
            this.appendProperty(TESTS_PROPERTY, path);
        }
        return this;
    }

    public ProjectDefinition addTests(File ... fileOrDirs) {
        for (File fileOrDir : fileOrDirs) {
            this.addTests(fileOrDir.getAbsolutePath());
        }
        return this;
    }

    public ProjectDefinition setTests(String ... paths) {
        this.resetTests();
        return this.addTests(paths);
    }

    public ProjectDefinition setTests(File ... fileOrDirs) {
        this.resetTests();
        for (File dir : fileOrDirs) {
            this.addTests(dir.getAbsolutePath());
        }
        return this;
    }

    public ProjectDefinition resetTests() {
        this.properties.remove(TESTS_PROPERTY);
        return this;
    }

    public ProjectDefinition addSubProject(ProjectDefinition child) {
        this.subProjects.add(child);
        child.setParent(this);
        return this;
    }

    @CheckForNull
    public ProjectDefinition getParent() {
        return this.parent;
    }

    public void remove() {
        if (this.parent != null) {
            this.parent.subProjects.remove(this);
            this.parent = null;
            this.subProjects.clear();
        }
    }

    private void setParent(ProjectDefinition parent) {
        this.parent = parent;
    }

    public List<ProjectDefinition> getSubProjects() {
        return this.subProjects;
    }

    private static List<String> trim(String[] strings) {
        ArrayList<String> result = new ArrayList<String>();
        for (String s : strings) {
            result.add(StringUtils.trim(s));
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectDefinition that = (ProjectDefinition)o;
        String key = this.getKey();
        return !(key == null ? that.getKey() != null : !key.equals(that.getKey()));
    }

    public int hashCode() {
        String key = this.getKey();
        return key != null ? key.hashCode() : 0;
    }
}

